"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhraseSuggestorUI = exports.PhraseSuggestor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Since both "phrase" and "phrases" filter inputs suggest values (if enabled and the field is
 * aggregatable), we pull out the common logic for requesting suggestions into this component
 * which both of them extend.
 */
class PhraseSuggestorUI extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "services", this.props.kibana.services);
    (0, _defineProperty2.default)(this, "abortController", void 0);
    (0, _defineProperty2.default)(this, "state", {
      suggestions: [],
      isLoading: false
    });
    (0, _defineProperty2.default)(this, "onSearchChange", value => {
      this.setState({
        isLoading: true
      });
      this.updateSuggestions(`${value}`);
    });
    (0, _defineProperty2.default)(this, "updateSuggestions", (0, _lodash.debounce)(async (query = '') => {
      var _this$props$suggestio;
      if (this.abortController) this.abortController.abort();
      this.abortController = new AbortController();
      const {
        indexPattern,
        field,
        timeRangeForSuggestionsOverride,
        filtersForSuggestions
      } = this.props;
      if (!field || !this.isSuggestingValues()) {
        return;
      }
      this.setState({
        isLoading: true
      });
      const suggestions = await this.services.unifiedSearch.autocomplete.getValueSuggestions({
        indexPattern,
        field,
        query,
        signal: this.abortController.signal,
        useTimeRange: timeRangeForSuggestionsOverride,
        boolFilter: (0, _esQuery.buildQueryFromFilters)(filtersForSuggestions, undefined).filter,
        method: filtersForSuggestions !== null && filtersForSuggestions !== void 0 && filtersForSuggestions.length ? 'terms_agg' : undefined,
        querySuggestionKey: (_this$props$suggestio = this.props.suggestionsAbstraction) === null || _this$props$suggestio === void 0 ? void 0 : _this$props$suggestio.type
      });
      this.setState({
        suggestions,
        isLoading: false
      });
    }, 500));
  }
  componentDidMount() {
    this.updateSuggestions();
  }
  componentWillUnmount() {
    if (this.abortController) this.abortController.abort();
  }
  isSuggestingValues() {
    var _field$esTypes;
    const shouldSuggestValues = this.services.uiSettings.get(_common.UI_SETTINGS.FILTERS_EDITOR_SUGGEST_VALUES);
    const {
      field
    } = this.props;
    const isVersionFieldType = field === null || field === void 0 ? void 0 : (_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.includes('version');
    return (
      // suggestions don't work for version fields
      shouldSuggestValues && field && field.aggregatable && field.type === 'string' && !isVersionFieldType
    );
  }
}
exports.PhraseSuggestorUI = PhraseSuggestorUI;
const PhraseSuggestor = exports.PhraseSuggestor = (0, _public.withKibana)(PhraseSuggestorUI);