"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.isOperator = exports.isOneOfOperator = exports.isNotOperator = exports.isNotOneOfOperator = exports.isNotBetweenOperator = exports.isLessThanOperator = exports.isGreaterOrEqualOperator = exports.isBetweenOperator = exports.existsOperator = exports.doesNotExistOperator = exports.OPERATORS = exports.FILTER_OPERATORS = void 0;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _fieldTypes = require("@kbn/field-types");
var _range_value_input = require("../range_value_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const strings = exports.strings = {
  getIsOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isOperatorOptionLabel', {
    defaultMessage: 'is'
  }),
  getIsNotOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotOperatorOptionLabel', {
    defaultMessage: 'is not'
  }),
  getIsOneOfOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isOneOfOperatorOptionLabel', {
    defaultMessage: 'is one of'
  }),
  getIsNotOneOfOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotOneOfOperatorOptionLabel', {
    defaultMessage: 'is not one of'
  }),
  getIsBetweenOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isBetweenOperatorOptionLabel', {
    defaultMessage: 'is between'
  }),
  getIsGreaterOrEqualOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.greaterThanOrEqualOptionLabel', {
    defaultMessage: 'greater or equal'
  }),
  getLessThanOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.lessThanOrEqualOptionLabel', {
    defaultMessage: 'less than'
  }),
  getIsNotBetweenOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.isNotBetweenOperatorOptionLabel', {
    defaultMessage: 'is not between'
  }),
  getExistsOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.existsOperatorOptionLabel', {
    defaultMessage: 'exists'
  }),
  getDoesNotExistOperatorOptionLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterEditor.doesNotExistOperatorOptionLabel', {
    defaultMessage: 'does not exist'
  })
};
let OPERATORS = exports.OPERATORS = /*#__PURE__*/function (OPERATORS) {
  OPERATORS["LESS"] = "less";
  OPERATORS["GREATER_OR_EQUAL"] = "greater_or_equal";
  OPERATORS["BETWEEN"] = "between";
  OPERATORS["IS"] = "is";
  OPERATORS["NOT_BETWEEN"] = "not_between";
  OPERATORS["IS_NOT"] = "is_not";
  OPERATORS["IS_ONE_OF"] = "is_one_of";
  OPERATORS["IS_NOT_ONE_OF"] = "is_not_one_of";
  OPERATORS["EXISTS"] = "exists";
  OPERATORS["DOES_NOT_EXIST"] = "does_not_exist";
  return OPERATORS;
}({});
const isSharedProps = {
  type: _esQuery.FILTERS.PHRASE,
  getParamsFromPrevOperator: (prevOperator, params) => {
    if (!prevOperator) return;
    if ([OPERATORS.IS, OPERATORS.IS_NOT].includes(prevOperator.id)) return params;
    if ([OPERATORS.IS_ONE_OF, OPERATORS.IS_NOT_ONE_OF].includes(prevOperator.id)) {
      if (Array.isArray(params) && params.length > 0) return params[0];
    }
  }
};
const isOperator = exports.isOperator = {
  ...isSharedProps,
  message: strings.getIsOperatorOptionLabel(),
  negate: false,
  id: OPERATORS.IS
};
const isNotOperator = exports.isNotOperator = {
  ...isSharedProps,
  message: strings.getIsNotOperatorOptionLabel(),
  negate: true,
  id: OPERATORS.IS_NOT
};
const isOneOfSharedProps = {
  type: _esQuery.FILTERS.PHRASES,
  fieldTypes: ['string', 'number', 'date', 'ip', 'geo_point', 'geo_shape'],
  getParamsFromPrevOperator: (prevOperator, params) => {
    if (!prevOperator) return;
    if ([OPERATORS.IS_ONE_OF, OPERATORS.IS_NOT_ONE_OF].includes(prevOperator.id)) return params;
    if ([OPERATORS.IS, OPERATORS.IS_NOT].includes(prevOperator.id) && typeof params === 'string') {
      if (!Array.isArray(params)) return [params];
    }
  }
};
const isOneOfOperator = exports.isOneOfOperator = {
  ...isOneOfSharedProps,
  message: strings.getIsOneOfOperatorOptionLabel(),
  negate: false,
  id: OPERATORS.IS_ONE_OF
};
const isNotOneOfOperator = exports.isNotOneOfOperator = {
  ...isOneOfSharedProps,
  message: strings.getIsNotOneOfOperatorOptionLabel(),
  negate: true,
  id: OPERATORS.IS_NOT_ONE_OF
};
const rangeOperatorsSharedProps = {
  type: _esQuery.FILTERS.RANGE,
  field: field => {
    var _field$esTypes;
    if (['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range'].includes(field.type)) return true;
    if (field.type === 'string' && (_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.includes(_fieldTypes.ES_FIELD_TYPES.VERSION)) return true;
    return false;
  }
};
const betweenGetParamsFromPrevOperator = (prevOperator, params) => {
  if (!prevOperator) return;
  if ([OPERATORS.LESS, OPERATORS.GREATER_OR_EQUAL, OPERATORS.BETWEEN, OPERATORS.NOT_BETWEEN].includes(prevOperator.id)) return params;
};
const isBetweenOperator = exports.isBetweenOperator = {
  ...rangeOperatorsSharedProps,
  message: strings.getIsBetweenOperatorOptionLabel(),
  id: OPERATORS.BETWEEN,
  negate: false,
  getParamsFromPrevOperator: betweenGetParamsFromPrevOperator
};
const isNotBetweenOperator = exports.isNotBetweenOperator = {
  ...rangeOperatorsSharedProps,
  message: strings.getIsNotBetweenOperatorOptionLabel(),
  negate: true,
  id: OPERATORS.NOT_BETWEEN,
  getParamsFromPrevOperator: betweenGetParamsFromPrevOperator
};
const isLessThanOperator = exports.isLessThanOperator = {
  ...rangeOperatorsSharedProps,
  message: strings.getLessThanOperatorOptionLabel(),
  id: OPERATORS.LESS,
  negate: false,
  getParamsFromPrevOperator: (prevOperator, params) => {
    if (!prevOperator) return;
    if ([OPERATORS.BETWEEN, OPERATORS.NOT_BETWEEN].includes(prevOperator.id) && (0, _range_value_input.isRangeParams)(params)) return {
      from: undefined,
      to: params === null || params === void 0 ? void 0 : params.to
    };
  }
};
const isGreaterOrEqualOperator = exports.isGreaterOrEqualOperator = {
  ...rangeOperatorsSharedProps,
  message: strings.getIsGreaterOrEqualOperatorOptionLabel(),
  id: OPERATORS.GREATER_OR_EQUAL,
  negate: false,
  getParamsFromPrevOperator: (prevOperator, params) => {
    if (!prevOperator) return;
    if ([OPERATORS.BETWEEN, OPERATORS.NOT_BETWEEN].includes(prevOperator.id) && (0, _range_value_input.isRangeParams)(params)) return {
      from: params === null || params === void 0 ? void 0 : params.from,
      to: undefined
    };
  }
};
const existsOperator = exports.existsOperator = {
  message: strings.getExistsOperatorOptionLabel(),
  type: _esQuery.FILTERS.EXISTS,
  negate: false,
  id: OPERATORS.EXISTS
};
const doesNotExistOperator = exports.doesNotExistOperator = {
  message: strings.getDoesNotExistOperatorOptionLabel(),
  type: _esQuery.FILTERS.EXISTS,
  negate: true,
  id: OPERATORS.DOES_NOT_EXIST
};
const FILTER_OPERATORS = exports.FILTER_OPERATORS = [isOperator, isNotOperator, isOneOfOperator, isNotOneOfOperator, isGreaterOrEqualOperator, isLessThanOperator, isBetweenOperator, isNotBetweenOperator, existsOperator, doesNotExistOperator];