"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseFilterEditorConfirmModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_editor/close_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getTitle: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.title', {
    defaultMessage: 'Unsaved changes'
  }),
  getCancelButton: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.cancelButton', {
    defaultMessage: 'Cancel'
  }),
  getConfirmButton: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.confirmButton', {
    defaultMessage: 'Discard changes'
  }),
  getWarningLabel: () => _i18n.i18n.translate('unifiedSearch.filter.closeEditorConfirmModal.warningLabel', {
    defaultMessage: 'If you leave now, your unsaved filters will be lost.'
  })
};
const CloseFilterEditorConfirmModal = exports.CloseFilterEditorConfirmModal = /*#__PURE__*/(0, _react.memo)(function CloseFilterEditorConfirmModal(props) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({
    "data-test-subj": "close-filter-editor-confirm-modal",
    "aria-labelledby": modalTitleId,
    title: strings.getTitle(),
    titleProps: {
      id: modalTitleId
    },
    cancelButtonText: strings.getCancelButton(),
    confirmButtonText: strings.getConfirmButton(),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, strings.getWarningLabel()));
});