"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreMatchingButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_search/public/dataview_picker/explore_matching_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ExploreMatchingButton = ({
  noDataViewMatches,
  indexMatches,
  dataViewSearchString,
  setPopoverIsOpen,
  onCreateDefaultAdHocDataView
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (onCreateDefaultAdHocDataView && noDataViewMatches && indexMatches > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      justifyContent: "spaceBetween",
      css: (0, _react2.css)`
          margin: ${euiTheme.size.s};
          margin-bottom: 0;
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      size: "s",
      "data-test-subj": "explore-matching-indices-button",
      onClick: () => {
        setPopoverIsOpen(false);
        onCreateDefaultAdHocDataView({
          title: dataViewSearchString
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.createForMatchingIndices', {
      defaultMessage: `Explore {indicesLength, plural,
              one {# matching index}
              other {# matching indices}}`,
      values: {
        indicesLength: indexMatches
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    })));
  }
  return null;
};
exports.ExploreMatchingButton = ExploreMatchingButton;