"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfallTourStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/trace_waterfall/full_screen_waterfall_tour_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const tourStepTitle = _i18n.i18n.translate('unifiedDocViewer.observability.traces.trace.tourStep.title', {
  defaultMessage: 'Trace insights in Discover'
});
const tourStepSubtitle = _i18n.i18n.translate('unifiedDocViewer.observability.traces.trace.tourStep.subtitle', {
  defaultMessage: 'New discover feature'
});
const tourStepOkButtonAriaLabel = fullScreenButtonLabel => {
  return _i18n.i18n.translate('unifiedDocViewer.contentFramework.section.tourStep.okButton', {
    defaultMessage: 'Close {action} tour',
    values: {
      action: fullScreenButtonLabel
    }
  });
};
const tourStepOkButtonLabel = _i18n.i18n.translate('unifiedDocViewer.contentFramework.section.tourStep.okButtonLabel', {
  defaultMessage: 'OK'
});
const fullscreenWaterfallTourStorageKey = 'fullscreenWaterfallTourDismissed';
const TraceWaterfallTourStep = ({
  actionId,
  fullScreenButtonLabel,
  onFullScreenLinkClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [dismissedActionTour, setDismissedActionTour] = (0, _useLocalStorage.default)(fullscreenWaterfallTourStorageKey, false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    anchor: `#${actionId}`,
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedDocViewer.observability.traces.trace.tourStep.content",
      defaultMessage: "You can now click {link} to view the full-screen waterfall and explore your trace data in context.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "traceWaterfallFullScreenActionTourLink",
          onClick: onFullScreenLinkClick,
          "aria-label": fullScreenButtonLabel,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 15
          }
        }, fullScreenButtonLabel)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }),
    isStepOpen: !dismissedActionTour,
    maxWidth: 350,
    onFinish: () => {},
    step: 1,
    stepsTotal: 1,
    title: tourStepTitle,
    subtitle: tourStepSubtitle,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": tourStepOkButtonAriaLabel(fullScreenButtonLabel),
      "data-test-subj": "traceWaterfallFullScreenActionTourOkButton",
      onClick: () => {
        setDismissedActionTour(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }, tourStepOkButtonLabel),
    zIndex: Number(euiTheme.levels.flyout),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.TraceWaterfallTourStep = TraceWaterfallTourStep;