"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimilarSpans = SimilarSpans;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _apmTypesShared = require("@kbn/apm-types-shared");
var _lazy_content_framework_section = require("../../../../content_framework/lazy_content_framework_section");
var _chart = require("../../../../content_framework/chart");
var _use_latency_chart = require("../../hooks/use_latency_chart");
var _use_data_sources = require("../../hooks/use_data_sources");
var _use_get_generate_discover_link = require("../../hooks/use_get_generate_discover_link");
var _get_esql_query = require("./get_esql_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/similar_spans/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sectionTitle = _i18n.i18n.translate('unifiedDocViewer.observability.traces.similarSpans', {
  defaultMessage: 'Similar spans'
});
const latencyTitle = _i18n.i18n.translate('unifiedDocViewer.observability.traces.similarSpans.latency.title', {
  defaultMessage: 'Latency'
});
const discoverBtnLabel = _i18n.i18n.translate('unifiedDocViewer.observability.traces.similarSpans.openInDiscover.button', {
  defaultMessage: 'Open in Discover'
});
const discoverBtnAria = _i18n.i18n.translate('unifiedDocViewer.observability.traces.similarSpans.openInDiscover.label', {
  defaultMessage: 'Open in Discover link'
});
function SimilarSpans({
  duration,
  spanName,
  serviceName,
  transactionName,
  transactionType,
  isOtelSpan
}) {
  var _latencyChart$data$di, _latencyChart$data, _latencyChart$data$pe, _latencyChart$data2, _latencyChart$data3, _latencyChart$data3$d;
  const latencyChart = (0, _use_latency_chart.useLatencyChart)({
    spanName,
    serviceName,
    transactionName,
    transactionType,
    isOtelSpan
  });
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    generateDiscoverLink
  } = (0, _use_get_generate_discover_link.useGetGenerateDiscoverLink)({
    indexPattern: indexes.apm.traces
  });
  const esqlQuery = (0, _get_esql_query.getEsqlQuery)({
    serviceName,
    spanName,
    transactionName,
    transactionType
  });
  const discoverUrl = (0, _react.useMemo)(() => generateDiscoverLink(esqlQuery), [generateDiscoverLink, esqlQuery]);
  const sectionActions = (0, _react.useMemo)(() => discoverUrl ? [{
    dataTestSubj: 'docViewerSimilarSpansOpenInDiscoverButton',
    label: discoverBtnLabel,
    href: discoverUrl,
    icon: 'discoverApp',
    ariaLabel: discoverBtnAria
  }] : [], [, discoverUrl]);
  return /*#__PURE__*/_react.default.createElement(_lazy_content_framework_section.ContentFrameworkSection, {
    id: "similarSpans",
    "data-test-subj": "docViewerSimilarSpansSection",
    title: sectionTitle,
    actions: sectionActions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.ContentFrameworkChart, {
    "data-test-subj": "docViewerSimilarSpansLatencyChart",
    title: latencyTitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apmUiShared.DurationDistributionChart, {
    data: (_latencyChart$data$di = (_latencyChart$data = latencyChart.data) === null || _latencyChart$data === void 0 ? void 0 : _latencyChart$data.distributionChartData) !== null && _latencyChart$data$di !== void 0 ? _latencyChart$data$di : [],
    markerValue: (_latencyChart$data$pe = (_latencyChart$data2 = latencyChart.data) === null || _latencyChart$data2 === void 0 ? void 0 : _latencyChart$data2.percentileThresholdValue) !== null && _latencyChart$data$pe !== void 0 ? _latencyChart$data$pe : 0,
    markerCurrentEvent: duration,
    hasData: !!((_latencyChart$data3 = latencyChart.data) !== null && _latencyChart$data3 !== void 0 && (_latencyChart$data3$d = _latencyChart$data3.distributionChartData) !== null && _latencyChart$data3$d !== void 0 && _latencyChart$data3$d.length),
    loading: latencyChart.loading,
    hasError: latencyChart.hasError,
    eventType: _apmTypesShared.ProcessorEvent.span,
    showAxisTitle: false,
    showLegend: false,
    isOtelData: isOtelSpan,
    "data-test-subj": "docViewerSimilarSpansDurationDistributionChart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  })));
}