"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNameLink = ServiceNameLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _react = _interopRequireDefault(require("react"));
var _plugin = require("../../../../plugin");
var _service_name_with_icon = require("./service_name_with_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/service_name_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SERVICE_OVERVIEW_LOCATOR_ID = 'serviceOverviewLocator';
function ServiceNameLink({
  serviceName,
  agentName,
  formattedServiceName,
  'data-test-subj': dataTestSubj
}) {
  var _core$application$cap;
  const {
    share: {
      url: urlService
    },
    core,
    data: dataService
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const canViewApm = ((_core$application$cap = core.application.capabilities.apm) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) || false;
  const {
    from: timeRangeFrom,
    to: timeRangeTo
  } = dataService.query.timefilter.timefilter.getTime();
  const apmLinkToServiceEntityLocator = urlService.locators.get(SERVICE_OVERVIEW_LOCATOR_ID);
  const href = apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.getRedirectUrl({
    serviceName,
    rangeFrom: timeRangeFrom,
    rangeTo: timeRangeTo
  });
  const routeLinkProps = href ? (0, _routerUtils.getRouterLinkProps)({
    href,
    onClick: () => {
      apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.navigate({
        serviceName,
        rangeFrom: timeRangeFrom,
        rangeTo: timeRangeTo
      });
    }
  }) : undefined;
  const content = /*#__PURE__*/_react.default.createElement(_service_name_with_icon.ServiceNameWithIcon, {
    agentName: agentName,
    serviceName: formattedServiceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 19
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canViewApm && routeLinkProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, routeLinkProps, {
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }), content) : content);
}