"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsFlyout = LogsFlyout;
exports.logsFlyoutId = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _objectUtils = require("@kbn/object-utils");
var _react = _interopRequireWildcard(require("react"));
var _ = require("..");
var _doc_viewer_logs_overview = _interopRequireDefault(require("../../../../../../doc_viewer_logs_overview"));
var _use_data_sources = require("../../../../hooks/use_data_sources");
var _use_adhoc_data_view = require("../../hooks/use_adhoc_data_view");
var _use_fetch_log = require("../../hooks/use_fetch_log");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/full_screen_waterfall/waterfall_flyout/logs_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const logsFlyoutId = exports.logsFlyoutId = 'logsFlyout';
function LogsFlyout({
  onCloseFlyout,
  id,
  dataView
}) {
  const {
    loading,
    logDoc,
    index
  } = (0, _use_fetch_log.useFetchLog)({
    id
  });
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    dataView: logDataView,
    error,
    loading: loadingDataView
  } = (0, _use_adhoc_data_view.useAdhocDataView)({
    index
  });
  const documentAsHit = (0, _react.useMemo)(() => {
    if (!logDoc || !id || !index) return null;
    return {
      id,
      raw: {
        _index: index,
        _id: id,
        _source: logDoc
      },
      flattened: (0, _objectUtils.flattenObject)(logDoc)
    };
  }, [id, logDoc, index]);
  return /*#__PURE__*/_react.default.createElement(_.WaterfallFlyout, {
    flyoutId: logsFlyoutId,
    onCloseFlyout: onCloseFlyout,
    dataView: dataView,
    hit: documentAsHit,
    loading: loading || loadingDataView,
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.logFlyout.title.log', {
      defaultMessage: 'Log document'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: error,
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 16
    }
  }) : null, documentAsHit && logDataView ? /*#__PURE__*/_react.default.createElement(_doc_viewer_logs_overview.default, {
    hit: documentAsHit,
    dataView: logDataView,
    indexes: indexes,
    showTraceWaterfall: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }) : null);
}