"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdhocDataView = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _plugin = require("../../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const errorMessage = _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.logFlyout.error', {
  defaultMessage: 'An error occurred while creating the data view'
});
const useAdhocDataView = ({
  index
}) => {
  const {
    data,
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [dataView, setDataView] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function createAdhocDataView() {
      if (!index) {
        return;
      }
      setLoading(true);
      setError(null);
      try {
        const _dataView = await data.dataViews.create({
          title: index,
          timeFieldName: '@timestamp'
        }, undefined, false);
        setDataView(_dataView);
      } catch (e) {
        setError(errorMessage);
        const err = e;
        core.notifications.toasts.addDanger({
          title: errorMessage,
          text: err.message
        });
      } finally {
        setLoading(false);
      }
    }
    createAdhocDataView();
  }, [index, data.dataViews, core.notifications.toasts]);
  return {
    dataView,
    error,
    loading
  };
};
exports.useAdhocDataView = useAdhocDataView;