"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchErrorsByTraceId = useFetchErrorsByTraceId;
var _reactHooks = require("@kbn/react-hooks");
var _plugin = require("../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1".
 */

const INITIAL_VALUE = {
  traceErrors: [],
  source: 'apm'
};
function useFetchErrorsByTraceId({
  traceId,
  docId
}) {
  const {
    discoverShared,
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const timeFilter = data.query.timefilter.timefilter.getAbsoluteTime();
  const fetchErrors = discoverShared.features.registry.getById('observability-traces-fetch-errors');
  const {
    loading,
    error,
    value
  } = (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    if (!fetchErrors) {
      return null;
    }
    return fetchErrors.fetchErrorsByTraceId({
      traceId,
      docId,
      start: timeFilter.from,
      end: timeFilter.to
    }, signal);
  }, [fetchErrors, traceId, docId, timeFilter.from, timeFilter.to]);
  return {
    loading,
    error,
    response: value || INITIAL_VALUE
  };
}