"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lazy_content_framework_section = require("../../../../content_framework/lazy_content_framework_section");
var _get_columns = require("./get_columns");
var _use_fetch_errors_by_trace_id = require("./use_fetch_errors_by_trace_id");
var _use_data_sources = require("../../hooks/use_data_sources");
var _use_get_generate_discover_link = require("../../hooks/use_get_generate_discover_link");
var _constants = require("../../common/constants");
var _create_trace_context_where_clause = require("../../common/create_trace_context_where_clause");
var _scrollable_section_wrapper = require("../../../../doc_viewer_logs_overview/scrollable_section_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/errors/errors_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sorting = {
  sort: {
    field: 'lastSeen',
    direction: 'desc'
  }
};
const ErrorsTable = exports.ErrorsTable = /*#__PURE__*/(0, _react.forwardRef)(({
  traceId,
  docId
}, ref) => {
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    generateDiscoverLink
  } = (0, _use_get_generate_discover_link.useGetGenerateDiscoverLink)({
    indexPattern: indexes.apm.errors
  });
  const {
    loading,
    error,
    response
  } = (0, _use_fetch_errors_by_trace_id.useFetchErrorsByTraceId)({
    traceId,
    docId
  });
  const {
    columns,
    openInDiscoverLink
  } = (0, _react.useMemo)(() => {
    const cols = (0, _get_columns.getColumns)({
      traceId,
      docId,
      generateDiscoverLink,
      source: response.source
    });
    const link = generateDiscoverLink((0, _create_trace_context_where_clause.createTraceContextWhereClause)({
      traceId,
      spanId: docId
    }));
    return {
      columns: cols,
      openInDiscoverLink: link
    };
  }, [traceId, docId, generateDiscoverLink, response.source]);
  if (loading || !error && response.traceErrors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_scrollable_section_wrapper.ScrollableSectionWrapper, {
    ref: ref,
    defaultState: "open",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, ({
    onToggle,
    forceState
  }) => /*#__PURE__*/_react.default.createElement(_lazy_content_framework_section.ContentFrameworkSection, {
    "data-test-subj": "unifiedDocViewerErrorsAccordion",
    id: "errorsSection",
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.errors', {
      defaultMessage: 'Errors'
    }),
    description: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.errors.description', {
      defaultMessage: 'Errors that occurred during this span and their causes'
    }),
    actions: openInDiscoverLink ? [{
      icon: 'discoverApp',
      label: _constants.OPEN_IN_DISCOVER_LABEL,
      ariaLabel: _constants.OPEN_IN_DISCOVER_LABEL_ARIAL_LABEL,
      href: openInDiscoverLink,
      dataTestSubj: 'unifiedDocViewerSpanLinksRefreshButton'
    }] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }), error ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.error', {
    defaultMessage: 'An error happened when trying to fetch data. Please try again'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    responsiveBreakpoint: false,
    items: response.traceErrors,
    columns: columns,
    pagination: {
      showPerPageOptions: false,
      pageSize: 5
    },
    sorting: sorting,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 19
    }
  })))));
});