"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.About = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _apmTypes = require("@kbn/apm-types");
var _eui = require("@elastic/eui");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _react2 = require("@emotion/react");
var _content_framework = require("../../../../content_framework");
var _helpers = require("../../helpers");
var _field_configurations = require("./field_configurations");
var _use_fetch_trace_root_item = require("../../doc_viewer_overview/hooks/use_fetch_trace_root_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/about/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spanFieldNames = [_apmTypes.SPAN_ID, _apmTypes.SPAN_NAME, _apmTypes.TRACE_ID, _apmTypes.SERVICE_NAME, _apmTypes.SPAN_DURATION, _apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE, _apmTypes.AT_TIMESTAMP, _apmTypes.HTTP_RESPONSE_STATUS_CODE, _apmTypes.SPAN_TYPE, _apmTypes.SPAN_SUBTYPE];
const transactionFieldNames = [_apmTypes.TRANSACTION_ID, _apmTypes.TRANSACTION_NAME, _apmTypes.TRACE_ID, _apmTypes.SERVICE_NAME, _apmTypes.TRANSACTION_DURATION, _apmTypes.AT_TIMESTAMP, _apmTypes.HTTP_RESPONSE_STATUS_CODE, _apmTypes.USER_AGENT_NAME, _apmTypes.USER_AGENT_VERSION];
const About = ({
  hit,
  dataView,
  filter,
  onAddColumn,
  onRemoveColumn
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isSpan = !(0, _helpers.isTransaction)(hit);
  const flattenedHit = (0, _discoverUtils.getFlattenedTraceDocumentOverview)(hit);
  const traceRootItem = (0, _use_fetch_trace_root_item.useFetchTraceRootItemContext)();
  const aboutFieldConfigurations = (0, _react.useMemo)(() => ({
    ...(0, _field_configurations.getSharedFieldConfigurations)(flattenedHit),
    ...(isSpan ? (0, _field_configurations.getSpanFieldConfigurations)(flattenedHit) : (0, _field_configurations.getTransactionFieldConfigurations)(flattenedHit))
  }), [flattenedHit, isSpan]);
  const durationField = isSpan ? _apmTypes.SPAN_DURATION !== null && _apmTypes.SPAN_DURATION !== void 0 ? _apmTypes.SPAN_DURATION : _apmTypes.DURATION : _apmTypes.TRANSACTION_DURATION;
  aboutFieldConfigurations[durationField] = {
    ...aboutFieldConfigurations[durationField],
    formatter: value => {
      var _traceRootItem$item;
      return /*#__PURE__*/_react.default.createElement(_apmUiShared.Duration, {
        duration: value,
        size: "xs",
        parent: {
          duration: traceRootItem === null || traceRootItem === void 0 ? void 0 : (_traceRootItem$item = traceRootItem.item) === null || _traceRootItem$item === void 0 ? void 0 : _traceRootItem$item.duration,
          type: 'trace'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 7
        }
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    css: (0, _react2.css)`
        padding-bottom: ${euiTheme.base / 4}px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_content_framework.ContentFrameworkTable, {
    fieldNames: isSpan ? spanFieldNames : transactionFieldNames,
    id: 'aboutTable',
    fieldConfigurations: aboutFieldConfigurations,
    dataView: dataView,
    hit: hit,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
exports.About = About;