"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTraceContextWhereClause = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _esqlComposer = require("@kbn/esql-composer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createTraceContextWhereClause = ({
  traceId,
  spanId,
  transactionId
}) => {
  const queryStrings = [];
  queryStrings.push(`${_discoverUtils.TRACE_ID_FIELD} == ?traceId`);
  if (transactionId) {
    queryStrings.push(`${_discoverUtils.TRANSACTION_ID_FIELD} == ?transactionId`);
  }
  if (spanId) {
    queryStrings.push(`${_discoverUtils.SPAN_ID_FIELD} == ?spanId`);
  }
  const filters = queryStrings.join(' AND ');
  const params = [{
    traceId
  }, {
    transactionId
  }, {
    spanId
  }];
  return (0, _esqlComposer.where)(filters, params);
};
exports.createTraceContextWhereClause = createTraceContextWhereClause;