"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributesOverview = AttributesOverview;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _table_filters = require("../../../doc_viewer_table/table_filters");
var _plugin = require("../../../../plugin");
var _get_height = require("../../../doc_viewer_source/get_height");
var _attributes_accordion = require("./attributes_accordion");
var _get_attributes_title = require("./get_attributes_title");
var _table = require("../../../doc_viewer_table/table");
var _attributes_empty_prompt = require("./attributes_empty_prompt");
var _group_attributes_fields = require("./group_attributes_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/attributes/doc_viewer_attributes_overview/attributes_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AttributesOverview({
  columns,
  columnsMeta,
  hit,
  dataView,
  textBasedHits,
  filter,
  decreaseAvailableHeightBy = _get_height.DEFAULT_MARGIN_BOTTOM,
  onAddColumn,
  onRemoveColumn
}) {
  const [containerRef, setContainerRef] = (0, _react.useState)(null);
  const {
    storage,
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const isEsqlMode = Array.isArray(textBasedHits);
  const showMultiFields = uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS);
  const {
    searchTerm,
    onChangeSearchTerm
  } = (0, _table_filters.useTableFilters)({
    storage,
    storageKey: _table_filters.LOCAL_STORAGE_KEY_SEARCH_TERM
  });
  const [areNullValuesHidden, setAreNullValuesHidden] = (0, _useLocalStorage.default)(_table.HIDE_NULL_VALUES, false);
  const flattened = hit.flattened;
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(Object.keys(flattened), dataView, showMultiFields), [flattened, dataView, showMultiFields]);
  const attributesTitle = (0, _get_attributes_title.getAttributesTitle)(hit);
  const allFields = Object.keys(flattened);
  const groupedFields = (0, _react.useMemo)(() => (0, _group_attributes_fields.groupAttributesFields)({
    allFields,
    flattened,
    searchTerm,
    shouldShowFieldHandler,
    isEsqlMode,
    areNullValuesHidden
  }), [allFields, flattened, searchTerm, shouldShowFieldHandler, isEsqlMode, areNullValuesHidden]);
  const {
    attributesFields,
    resourceAttributesFields,
    scopeAttributesFields
  } = groupedFields;
  const containerHeight = containerRef ? (0, _get_height.getTabContentAvailableHeight)(containerRef, decreaseAvailableHeightBy) : 0;
  const filterFieldsBySearchTerm = fields => fields.filter(field => field.displayName.toLowerCase().includes(searchTerm.toLowerCase()) || field.name.toLowerCase().includes(searchTerm.toLowerCase()));
  const accordionConfigs = [{
    id: 'signal_attributes',
    title: attributesTitle,
    ariaLabel: attributesTitle,
    fields: filterFieldsBySearchTerm(attributesFields),
    tooltipMessage: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.signalAttributesTooltip', {
      defaultMessage: 'Metadata added by the instrumentation library to describe the telemetry data (e.g., HTTP method, user agent).'
    })
  }, {
    id: 'resource_attributes',
    title: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.resourceAttributesTitle', {
      defaultMessage: 'Resource attributes'
    }),
    ariaLabel: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.resourceAttributesTitle.ariaLabel', {
      defaultMessage: 'Resource attributes'
    }),
    fields: filterFieldsBySearchTerm(resourceAttributesFields),
    tooltipMessage: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.resourceAttributesTooltip', {
      defaultMessage: 'Metadata originally set at the source of the telemetry, such as in the SDK or agent that generated the data.'
    })
  }, {
    id: 'scope_attributes',
    title: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.scopeAttributesTitle', {
      defaultMessage: 'Scope attributes'
    }),
    ariaLabel: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.scopeAttributesTitle.ariaLabel', {
      defaultMessage: 'Scope attributes'
    }),
    fields: filterFieldsBySearchTerm(scopeAttributesFields),
    tooltipMessage: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.scopeAttributesTooltip', {
      defaultMessage: 'Metadata associated with the instrumentation scope (i.e., the library/module that produced the telemetry), helping identify its origin and version.'
    })
  }];
  const onHideNullValuesChange = (0, _react.useCallback)(e => {
    setAreNullValuesHidden(e.target.checked);
  }, [setAreNullValuesHidden]);
  const noFields = attributesFields.length === 0 && resourceAttributesFields.length === 0 && scopeAttributesFields.length === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    ref: setContainerRef,
    css: containerHeight ? (0, _react2.css)`
              max-height: ${containerHeight}px;
              overflow: hidden;
            ` : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.placeholder', {
      defaultMessage: 'Search attributes names or values'
    }),
    value: searchTerm,
    onChange: e => onChangeSearchTerm(e.target.value),
    fullWidth: true,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, isEsqlMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('unifiedDocViewer.hideNullValues.switchLabel', {
      defaultMessage: 'Hide null fields',
      description: 'Switch label to hide fields with null values in the table'
    }),
    checked: areNullValuesHidden !== null && areNullValuesHidden !== void 0 ? areNullValuesHidden : false,
    onChange: onHideNullValuesChange,
    compressed: true,
    "data-test-subj": "unifiedDocViewerHideNullValuesSwitch",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
          overflow: auto;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, noFields ? /*#__PURE__*/_react.default.createElement(_attributes_empty_prompt.AttributesEmptyPrompt, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, accordionConfigs.map(({
    id,
    title,
    ariaLabel,
    fields,
    tooltipMessage
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_attributes_accordion.AttributesAccordion, {
    id: id,
    title: title,
    ariaLabel: ariaLabel,
    tooltipMessage: tooltipMessage,
    fields: fields,
    hit: hit,
    dataView: dataView,
    columns: columns,
    columnsMeta: columnsMeta,
    searchTerm: searchTerm,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    filter: filter,
    isEsqlMode: isEsqlMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 19
    }
  })))))));
}