"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributesAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _attributes_table = require("./attributes_table");
var _attributes_empty_prompt = require("./attributes_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/attributes/doc_viewer_attributes_overview/attributes_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const AttributesAccordion = ({
  id,
  title,
  tooltipMessage,
  fields,
  hit,
  dataView,
  columns,
  columnsMeta,
  searchTerm,
  onAddColumn,
  onRemoveColumn,
  filter,
  isEsqlMode = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      css: {
        marginRight: euiTheme.size.xs
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "aria-label": tooltipMessage,
      type: "question",
      color: "subdued",
      size: "s",
      content: tooltipMessage,
      iconProps: {
        className: 'eui-alignTop'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    })),
    initialIsOpen: fields.length > 0,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, fields.length),
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, fields.length === 0 ? /*#__PURE__*/_react.default.createElement(_attributes_empty_prompt.AttributesEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_attributes_table.AttributesTable, {
    hit: hit,
    dataView: dataView,
    columns: columns,
    columnsMeta: columnsMeta,
    fields: fields,
    searchTerm: searchTerm,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    filter: filter,
    isEsqlMode: isEsqlMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }));
};
exports.AttributesAccordion = AttributesAccordion;