"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_MARGIN_BOTTOM = void 0;
exports.getHeight = getHeight;
exports.getTabContentAvailableHeight = getTabContentAvailableHeight;
var _source = require("./source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Displayed margin of the tab content to the window bottom
const DEFAULT_MARGIN_BOTTOM = exports.DEFAULT_MARGIN_BOTTOM = 16;
function getTabContentAvailableHeight(elementRef, decreaseAvailableHeightBy) {
  if (!elementRef) {
    return 0;
  }

  // assign a good height filling the available space of the document flyout
  const position = elementRef.getBoundingClientRect();
  return window.innerHeight - position.top - decreaseAvailableHeightBy;
}
function getHeight(editor, decreaseAvailableHeightBy) {
  const editorElement = editor === null || editor === void 0 ? void 0 : editor.getDomNode();
  if (!editorElement) {
    return 0;
  }
  const result = getTabContentAvailableHeight(editorElement, decreaseAvailableHeightBy);
  return Math.max(result, _source.MIN_HEIGHT);
}