"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StacktraceContent = StacktraceContent;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _apm_stacktrace = require("./apm_stacktrace");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/sub_components/stacktrace/stacktrace_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function StacktraceContent({
  hit,
  dataView
}) {
  const errorStackTrace = (0, _discoverUtils.getFieldValue)(hit, _discoverUtils.fieldConstants.ERROR_STACK_TRACE);
  const dataStreamTypeField = (0, _discoverUtils.getFieldValue)(hit, _discoverUtils.fieldConstants.DATASTREAM_TYPE_FIELD);
  const dataStreamDatasetField = (0, _discoverUtils.getFieldValue)(hit, _discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD);
  if (dataStreamTypeField === _apm_stacktrace.APM_ERROR_DATASTREAM_FIELDS.dataStreamType && dataStreamDatasetField === _apm_stacktrace.APM_ERROR_DATASTREAM_FIELDS.dataStreamDataset) {
    return /*#__PURE__*/_react.default.createElement(_apm_stacktrace.ApmStacktrace, {
      hit: hit,
      dataView: dataView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    });
  }
  if (errorStackTrace) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 12
      }
    }, errorStackTrace);
  }
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('unifiedDocViewer.stacktraceSection.errorMessage', {
    defaultMessage: 'Failed to load stacktrace'
  }));
}