"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiThemeVars = exports.euiLightVars = exports.euiDarkVars = exports.darkMode = exports._setDarkMode = void 0;
exports.getEuiThemeVars = getEuiThemeVars;
exports.version = exports.tag = void 0;
var _eui_theme_amsterdam_light = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_amsterdam_light.json"));
var _eui_theme_amsterdam_dark = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_amsterdam_dark.json"));
var _eui_theme_borealis_light = _interopRequireDefault(require("@elastic/eui-theme-borealis/lib/eui_theme_borealis_light.json"));
var _eui_theme_borealis_dark = _interopRequireDefault(require("@elastic/eui-theme-borealis/lib/eui_theme_borealis_dark.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const globals = typeof window === 'undefined' ? {} : window;
// in the Kibana app we can rely on this global being defined, but in
// some cases (like jest) the global is undefined
/** @deprecated theme can be dynamic now, access is discouraged */
const tag = exports.tag = globals.__kbnThemeTag__ || 'v8light';
/** @deprecated theme can be dynamic now, access is discouraged */
const version = exports.version = 8;
/** @deprecated theme can be dynamic now, access is discouraged */
const darkMode = exports.darkMode = tag.endsWith('dark');
let isDarkMode = darkMode;
const _setDarkMode = mode => {
  isDarkMode = mode;
};
exports._setDarkMode = _setDarkMode;
const getThemeVars = () => {
  var _globals$__kbnThemeTa;
  if (globals !== null && globals !== void 0 && (_globals$__kbnThemeTa = globals.__kbnThemeTag__) !== null && _globals$__kbnThemeTa !== void 0 && _globals$__kbnThemeTa.includes('borealis')) {
    return {
      light: _eui_theme_borealis_light.default,
      dark: _eui_theme_borealis_dark.default
    };
  }
  return {
    light: _eui_theme_amsterdam_light.default,
    dark: _eui_theme_amsterdam_dark.default
  };
};
const euiLightVars = exports.euiLightVars = getThemeVars().light;
const euiDarkVars = exports.euiDarkVars = getThemeVars().dark;

/**
 * EUI Theme vars that automatically adjust to light/dark theme
 */
const euiThemeVars = exports.euiThemeVars = new Proxy(isDarkMode ? getThemeVars().dark : getThemeVars().light, {
  get(accessedTarget, accessedKey, ...rest) {
    return Reflect.get(isDarkMode ? getThemeVars().dark : getThemeVars().light, accessedKey, ...rest);
  }
});
function getEuiThemeVars(theme) {
  if (theme.name === `borealis`) {
    return theme.darkMode ? _eui_theme_borealis_dark.default : _eui_theme_borealis_light.default;
  }
  return theme.darkMode ? _eui_theme_amsterdam_dark.default : _eui_theme_amsterdam_light.default;
}