"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Uuid = exports.TsLib = exports.StyledComponents = exports.SaferLodashSet = exports.Rxjs = exports.Reselect = exports.ReduxjsToolkit = exports.Redux = exports.ReactUse = exports.ReactRouterDomV5Compat = exports.ReactRouterDom = exports.ReactRouter = exports.ReactRedux = exports.ReactQueryDevtools = exports.ReactQuery = exports.ReactDomServer = exports.ReactDom = exports.React = exports.MonacoBarePluginApi = exports.MomentTimezone = exports.Moment = exports.LodashFp = exports.Lodash = exports.KbnUiTheme = exports.KbnStd = exports.KbnSharedUxRouter = exports.KbnSharedUxErrorBoundary = exports.KbnSearchErrors = exports.KbnRison = exports.KbnReactKibanaMount = exports.KbnReactKibanaContextTheme = exports.KbnReactKibanaContextRoot = exports.KbnReactKibanaContextRender = exports.KbnReactKibanaContextCommon = exports.KbnMonaco = exports.KbnI18nReact = exports.KbnI18n = exports.KbnEsqlAst = exports.KbnEsQuery = exports.KbnEbtTools = exports.KbnDatemath = exports.KbnCryptoBrowser = exports.KbnCodeEditor = exports.KbnAnalytics = exports.Jquery = exports.IoTsThrowReporter = exports.IoTsReporter = exports.IoTsPathReporter = exports.IoTs = exports.Immer = exports.History = exports.HelloPangeaDnd = exports.FpTs = exports.FastestLevenshtein = exports.EmotionReact = exports.EmotionCache = exports.ElasticNumeral = exports.ElasticEuiThemeBorealis = exports.ElasticEuiLibServicesThemeWarning = exports.ElasticEuiLibComponentsUseIsNestedEuiProvider = exports.ElasticEui = exports.ElasticCharts = exports.ElasticApmRumCore = exports.Classnames = exports.ChromaJs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

require('./polyfills');
// Optional prototype hardening. This must occur immediately after polyfills.
if (typeof window.__kbnHardenPrototypes__ !== 'boolean') {
  throw new Error('Invariant bootstrap failure: __kbnHardenPrototypes__ must be set to true or false');
}
if (window.__kbnHardenPrototypes__) {
  require('@kbn/security-hardening/prototype');
}
const Jquery = exports.Jquery = require('jquery');
window.$ = window.jQuery = Jquery;

// stateful deps
const KbnUiTheme = exports.KbnUiTheme = require('@kbn/ui-theme');
const KbnI18n = exports.KbnI18n = require('@kbn/i18n');
const KbnI18nReact = exports.KbnI18nReact = require('@kbn/i18n-react');
const EmotionCache = exports.EmotionCache = require('@emotion/cache');
const EmotionReact = exports.EmotionReact = require('@emotion/react');
const Moment = exports.Moment = require('moment');
const MomentTimezone = exports.MomentTimezone = require('moment-timezone/moment-timezone');
const FpTs = exports.FpTs = require('fp-ts');
const IoTs = exports.IoTs = require('io-ts');
const IoTsReporter = exports.IoTsReporter = require('io-ts/Reporter');
const IoTsPathReporter = exports.IoTsPathReporter = require('io-ts/PathReporter');
const IoTsThrowReporter = exports.IoTsThrowReporter = require('io-ts/ThrowReporter');
const KbnMonaco = exports.KbnMonaco = require('@kbn/monaco');
const MonacoBarePluginApi = exports.MonacoBarePluginApi = require('@kbn/monaco').BarePluginApi;
const React = exports.React = require('react');
const ReactDom = exports.ReactDom = require('react-dom');
const ReactDomServer = exports.ReactDomServer = require('react-dom/server');
// eslint-disable-next-line @kbn/eslint/module_migration
const ReactRouter = exports.ReactRouter = require('react-router');
const ReactRouterDom = exports.ReactRouterDom = require('react-router-dom');
const ReactRouterDomV5Compat = exports.ReactRouterDomV5Compat = require('react-router-dom-v5-compat');
// eslint-disable-next-line @kbn/eslint/module_migration
const StyledComponents = exports.StyledComponents = require('styled-components');
const FastestLevenshtein = exports.FastestLevenshtein = require('fastest-levenshtein');
const ReactUse = exports.ReactUse = {
  useAsync: require('react-use/lib/useAsync'),
  useAsyncFn: require('react-use/lib/useAsyncFn'),
  useDebounce: require('react-use/lib/useDebounce'),
  useDeepCompareEffect: require('react-use/lib/useDeepCompareEffect'),
  useEffectOnce: require('react-use/lib/useEffectOnce'),
  useEvent: require('react-use/lib/useEvent'),
  useLatest: require('react-use/lib/useLatest'),
  useList: require('react-use/lib/useList'),
  useLocalStorage: require('react-use/lib/useLocalStorage'),
  useMount: require('react-use/lib/useMount'),
  useMountedState: require('react-use/lib/useMountedState'),
  usePrevious: require('react-use/lib/usePrevious'),
  useSessionStorage: require('react-use/lib/useSessionStorage'),
  useTimeoutFn: require('react-use/lib/useTimeoutFn'),
  useToggle: require('react-use/lib/useToggle'),
  useUnmount: require('react-use/lib/useUnmount'),
  useUpdateEffect: require('react-use/lib/useUpdateEffect')
};
Moment.tz.load(require('moment-timezone/data/packed/latest.json'));

// big deps which are locked to a single version
const Rxjs = exports.Rxjs = require('rxjs');
const ElasticNumeral = exports.ElasticNumeral = require('@elastic/numeral');
const ElasticCharts = exports.ElasticCharts = require('@elastic/charts');
const ElasticEui = exports.ElasticEui = require('@elastic/eui');
const ElasticEuiLibComponentsUseIsNestedEuiProvider = exports.ElasticEuiLibComponentsUseIsNestedEuiProvider = require('@elastic/eui/optimize/es/components/provider/nested');
const ElasticEuiLibServicesThemeWarning = exports.ElasticEuiLibServicesThemeWarning = require('@elastic/eui/optimize/es/services/theme/warning');
const ElasticEuiThemeBorealis = exports.ElasticEuiThemeBorealis = require('@elastic/eui-theme-borealis');
const KbnDatemath = exports.KbnDatemath = require('@kbn/datemath');
const HelloPangeaDnd = exports.HelloPangeaDnd = require('@hello-pangea/dnd/dist/dnd');
const ReduxjsToolkit = exports.ReduxjsToolkit = require('@reduxjs/toolkit');
const ReactRedux = exports.ReactRedux = require('react-redux');
const Redux = exports.Redux = require('redux');
const Immer = exports.Immer = require('immer');
const Reselect = exports.Reselect = require('reselect');
const Lodash = exports.Lodash = require('lodash');
const LodashFp = exports.LodashFp = require('lodash/fp');
const ChromaJs = exports.ChromaJs = require('chroma-js');

// runtime deps which don't need to be copied across all bundles
const TsLib = exports.TsLib = require('tslib');
const Uuid = exports.Uuid = require('uuid');
const KbnAnalytics = exports.KbnAnalytics = require('@kbn/analytics');
const KbnCryptoBrowser = exports.KbnCryptoBrowser = require('@kbn/crypto-browser');
const KbnEsQuery = exports.KbnEsQuery = require('@kbn/es-query');
const KbnSearchErrors = exports.KbnSearchErrors = require('@kbn/search-errors');
const KbnStd = exports.KbnStd = require('@kbn/std');
const SaferLodashSet = exports.SaferLodashSet = require('@kbn/safer-lodash-set');
const KbnSharedUxErrorBoundary = exports.KbnSharedUxErrorBoundary = require('@kbn/shared-ux-error-boundary');
const KbnRison = exports.KbnRison = require('@kbn/rison');
const History = exports.History = require('history');
const Classnames = exports.Classnames = require('classnames');
const ReactQuery = exports.ReactQuery = require('@tanstack/react-query');
const ReactQueryDevtools = exports.ReactQueryDevtools = require('@tanstack/react-query-devtools');
const KbnCodeEditor = exports.KbnCodeEditor = require('@kbn/code-editor');
const KbnEsqlAst = exports.KbnEsqlAst = require('@kbn/esql-ast');
const KbnEbtTools = exports.KbnEbtTools = require('@kbn/ebt-tools');
const ElasticApmRumCore = exports.ElasticApmRumCore = require('@elastic/apm-rum-core');
const KbnReactKibanaContextCommon = exports.KbnReactKibanaContextCommon = require('@kbn/react-kibana-context-common');
const KbnReactKibanaContextRoot = exports.KbnReactKibanaContextRoot = require('@kbn/react-kibana-context-root');
const KbnReactKibanaContextRender = exports.KbnReactKibanaContextRender = require('@kbn/react-kibana-context-render');
const KbnReactKibanaContextTheme = exports.KbnReactKibanaContextTheme = require('@kbn/react-kibana-context-theme');
const KbnSharedUxRouter = exports.KbnSharedUxRouter = require('@kbn/shared-ux-router');
const KbnReactKibanaMount = exports.KbnReactKibanaMount = require('@kbn/react-kibana-mount');