"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncObservable = void 0;
var _react = require("react");
var _useIsomorphicLayoutEffect = _interopRequireDefault(require("react-use/lib/useIsomorphicLayoutEffect"));
var _useUpdate = _interopRequireDefault(require("react-use/lib/useUpdate"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useSyncObservable = observable => {
  const firstRef = (0, _react.useRef)(true);
  const valueRef = (0, _react.useRef)();
  const update = (0, _useUpdate.default)();
  const subscriptionRef = (0, _react.useRef)(undefined);
  subscriptionRef.current = (0, _react.useMemo)(() => {
    if (subscriptionRef.current) {
      subscriptionRef.current.unsubscribe();
      subscriptionRef.current = undefined;
      firstRef.current = true;
    }
    return observable.subscribe(value => {
      valueRef.current = value;
      if (firstRef.current) firstRef.current = false;
      update();
    });
  }, [observable, update]);
  (0, _useIsomorphicLayoutEffect.default)(() => () => {
    if (subscriptionRef.current) {
      subscriptionRef.current.unsubscribe();
    }
  }, []);
  return valueRef.current;
};
exports.useSyncObservable = useSyncObservable;