"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateList = void 0;
var _eui = require("@elastic/eui");
var React = _interopRequireWildcard(require("react"));
var _drilldown_template_table = require("../../components/drilldown_template_table");
var _context = require("../context");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/template_picker/template_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateList = ({
  items
}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const tableItems = React.useMemo(() => {
    return items.map(item => {
      const factory = drilldowns.deps.actionFactories.find(({
        id
      }) => id === item.factoryId);
      const trigger = drilldowns.deps.getTrigger(item.triggers[0]);
      const tableItem = {
        id: item.id,
        name: item.name,
        icon: item.icon,
        description: item.description,
        triggerIncompatible: !drilldowns.deps.triggers.find(t => t === trigger.id)
      };
      if (factory) {
        const context = drilldowns.getActionFactoryContext();
        tableItem.actionName = factory.getDisplayName(context);
        tableItem.actionIcon = factory.getIconType(context);
      }
      if (trigger) {
        tableItem.trigger = trigger.title;
      }
      return tableItem;
    });
  }, [drilldowns, items]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, _i18n.txtLabel)), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_drilldown_template_table.DrilldownTemplateTable, {
    items: tableItems,
    onCreate: drilldowns.onCreateFromTemplate,
    onClone: drilldowns.onClone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
exports.TemplateList = TemplateList;