"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactoryPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _action_factory_picker = require("../../../../components/action_factory_picker");
var _context = require("../context");
var _action_factory_view = require("../action_factory_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/action_factory_picker/action_factory_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ActionFactoryPicker = ({}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const factory = drilldowns.useActionFactory();
  const context = _react.default.useMemo(() => drilldowns.getActionFactoryContext(), [drilldowns]);
  const compatibleFactories = drilldowns.useCompatibleActionFactories(context);
  if (!!factory) {
    return /*#__PURE__*/_react.default.createElement(_action_factory_view.ActionFactoryView, {
      factory: factory,
      context: context,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 12
      }
    });
  }
  if (!compatibleFactories) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_action_factory_picker.ActionFactoryPicker, {
    actionFactories: compatibleFactories,
    context: context,
    onSelect: actionFactory => {
      drilldowns.setActionFactory(actionFactory);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.ActionFactoryPicker = ActionFactoryPicker;