"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trigger_picker_item = require("./trigger_picker_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/components/trigger_picker/trigger_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const txtTriggerPickerLabel = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerLabel', {
  defaultMessage: 'Show option on:'
});
const txtTriggerPickerHelpText = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerHelpText', {
  defaultMessage: "What's this?"
});
const txtTriggerPickerHelpTooltip = _i18n.i18n.translate('uiActionsEnhanced.components.actionWizard.triggerPickerHelpTooltip', {
  defaultMessage: 'Determines when the drilldown appears in context menu'
});
const TriggerPicker = ({
  items,
  selected = [],
  docs,
  disabled,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    "data-test-subj": `triggerPicker`,
    legend: {
      children: !!docs && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 15
        }
      }, txtTriggerPickerLabel), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: txtTriggerPickerHelpTooltip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docs,
        target: 'blank',
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 17
        }
      }, txtTriggerPickerHelpText))))
    },
    css: {
      maxWidth: `80%`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, items.map(trigger => /*#__PURE__*/_react.default.createElement(_trigger_picker_item.TriggerPickerItem, {
    key: trigger.id,
    id: trigger.id,
    title: trigger.title,
    description: trigger.description,
    checked: trigger.id === selected[0],
    disabled: disabled,
    onSelect: id => onChange([id]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })));
};
exports.TriggerPicker = TriggerPicker;