"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_SELECTED_ACTION_FACTORY = exports.TEST_SUBJ_ACTION_FACTORY_ITEM = exports.ActionWizard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/components/action_wizard/action_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ActionWizard = ({
  currentActionFactory,
  actionFactories,
  onActionFactoryChange,
  onConfigChange,
  config,
  context,
  onSelectedTriggersChange,
  getTriggerInfo,
  triggers,
  triggerPickerDocsLink
}) => {
  var _context$triggers2;
  // auto pick action factory if there is only 1 available
  _react.default.useEffect(() => {
    if (!currentActionFactory && actionFactories.length === 1 && actionFactories[0].isCompatibleLicense()) {
      onActionFactoryChange(actionFactories[0]);
    }
  }, [currentActionFactory, actionFactories, actionFactories.length, onActionFactoryChange]);

  // auto pick selected trigger if none is picked
  _react.default.useEffect(() => {
    var _context$triggers$len, _context$triggers;
    if (currentActionFactory && !(((_context$triggers$len = (_context$triggers = context.triggers) === null || _context$triggers === void 0 ? void 0 : _context$triggers.length) !== null && _context$triggers$len !== void 0 ? _context$triggers$len : 0) > 0)) {
      const actionTriggers = getTriggersForActionFactory(currentActionFactory, triggers);
      if (actionTriggers.length > 0) {
        onSelectedTriggersChange([actionTriggers[0]]);
      }
    }
  }, [currentActionFactory, triggers, (_context$triggers2 = context.triggers) === null || _context$triggers2 === void 0 ? void 0 : _context$triggers2.length, onSelectedTriggersChange]);
  if (currentActionFactory) {
    if (!config) return null;
    const allTriggers = getTriggersForActionFactory(currentActionFactory, triggers);
    return /*#__PURE__*/_react.default.createElement(SelectedActionFactory, {
      actionFactory: currentActionFactory,
      showDeselect: actionFactories.length > 1,
      onDeselect: () => {
        onActionFactoryChange(undefined);
      },
      context: context,
      config: config,
      onConfigChange: newConfig => {
        onConfigChange(newConfig);
      },
      allTriggers: allTriggers,
      getTriggerInfo: getTriggerInfo,
      onSelectedTriggersChange: onSelectedTriggersChange,
      triggerPickerDocsLink: triggerPickerDocsLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(ActionFactorySelector, {
    context: context,
    actionFactories: actionFactories,
    onActionFactorySelected: onActionFactoryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  });
};
exports.ActionWizard = ActionWizard;
const TriggerPicker = ({
  triggers,
  selectedTriggers,
  getTriggerInfo,
  onSelectedTriggersChange,
  triggerPickerDocsLink
}) => {
  const selectedTrigger = selectedTriggers ? selectedTriggers[0] : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    "data-test-subj": `triggerPicker`,
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 15
        }
      }, _i18n.txtTriggerPickerLabel), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.txtTriggerPickerHelpTooltip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: triggerPickerDocsLink,
        target: 'blank',
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 17
        }
      }, _i18n.txtTriggerPickerHelpText))))
    },
    css: {
      maxWidth: `80%`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, triggers.map(trigger => {
    var _getTriggerInfo$title, _getTriggerInfo, _getTriggerInfo2, _getTriggerInfo3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: trigger,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
      id: trigger,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xxs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 19
        }
      }, (_getTriggerInfo$title = (_getTriggerInfo = getTriggerInfo(trigger)) === null || _getTriggerInfo === void 0 ? void 0 : _getTriggerInfo.title) !== null && _getTriggerInfo$title !== void 0 ? _getTriggerInfo$title : 'Unknown')), ((_getTriggerInfo2 = getTriggerInfo(trigger)) === null || _getTriggerInfo2 === void 0 ? void 0 : _getTriggerInfo2.description) && /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 23
        }
      }, (_getTriggerInfo3 = getTriggerInfo(trigger)) === null || _getTriggerInfo3 === void 0 ? void 0 : _getTriggerInfo3.description)))),
      name: trigger,
      value: trigger,
      checked: selectedTrigger === trigger,
      onChange: () => onSelectedTriggersChange([trigger]),
      "data-test-subj": `triggerPicker-${trigger}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }));
  }));
};
const TEST_SUBJ_SELECTED_ACTION_FACTORY = exports.TEST_SUBJ_SELECTED_ACTION_FACTORY = 'selectedActionFactory';
const SelectedActionFactory = ({
  actionFactory,
  onDeselect,
  showDeselect,
  onConfigChange,
  config,
  context,
  allTriggers,
  getTriggerInfo,
  onSelectedTriggersChange,
  triggerPickerDocsLink
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "auaActionWizard__selectedActionFactoryContainer",
    "data-test-subj": `${TEST_SUBJ_SELECTED_ACTION_FACTORY}-${actionFactory.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("header", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 9
    }
  }, actionFactory.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionFactory.getIconType(context),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }, actionFactory.getDisplayName(context), ' ', actionFactory.isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.txtBetaActionFactoryLabel,
    tooltipContent: _i18n.txtBetaActionFactoryTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 19
    }
  })))), showDeselect && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: () => onDeselect(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 15
    }
  }, _i18n.txtChangeButton)))), allTriggers.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(TriggerPicker, {
    triggers: allTriggers,
    getTriggerInfo: getTriggerInfo,
    selectedTriggers: context.triggers,
    onSelectedTriggersChange: onSelectedTriggersChange,
    triggerPickerDocsLink: triggerPickerDocsLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(actionFactory.CollectConfig, {
    config: config,
    onConfig: onConfigChange,
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 9
    }
  })));
};
const TEST_SUBJ_ACTION_FACTORY_ITEM = exports.TEST_SUBJ_ACTION_FACTORY_ITEM = 'actionFactoryItem';
const ActionFactorySelector = ({
  actionFactories,
  onActionFactorySelected,
  context
}) => {
  if (actionFactories.length === 0) {
    // this is not user facing, as it would be impossible to get into this state
    // just leaving for dev purposes for troubleshooting
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 12
      }
    }, "No action factories to pick from");
  }

  // The below style is applied to fix Firefox rendering bug.
  // See: https://github.com/elastic/kibana/pull/61219/#pullrequestreview-402903330
  const firefoxBugFix = {
    willChange: 'opacity'
  };

  /**
   * make sure not compatible factories are in the end
   */
  const ensureOrder = factories => {
    const compatibleLicense = factories.filter(f => f.isCompatibleLicense());
    const notCompatibleLicense = factories.filter(f => !f.isCompatibleLicense());
    return [...compatibleLicense.sort((f1, f2) => f2.order - f1.order), ...notCompatibleLicense.sort((f1, f2) => f2.order - f1.order)];
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: true,
    style: firefoxBugFix,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 5
    }
  }, ensureOrder(actionFactories).map(actionFactory => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: actionFactory.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !actionFactory.isCompatibleLicense() && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Insufficient license level",
      id: "uiActionsEnhanced.components.actionWizard.insufficientLicenseLevelTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      '.euiKeyPadMenuItem__label': {
        height: euiTheme.size.xl
      }
    }),
    label: actionFactory.getDisplayName(context),
    "data-test-subj": `${TEST_SUBJ_ACTION_FACTORY_ITEM}-${actionFactory.id}`,
    onClick: () => onActionFactorySelected(actionFactory),
    disabled: !actionFactory.isCompatibleLicense(),
    betaBadgeLabel: actionFactory.isBeta ? _i18n.txtBetaActionFactoryLabel : undefined,
    betaBadgeTooltipContent: actionFactory.isBeta ? _i18n.txtBetaActionFactoryTooltip : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 13
    }
  }, actionFactory.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionFactory.getIconType(context),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 17
    }
  }))))));
};
function getTriggersForActionFactory(actionFactory, allTriggers) {
  return actionFactory.supportedTriggers().filter(trigger => allTriggers.includes(trigger));
}