"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateKuery = validateKuery;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// common properties on time_series_query and alert_type_params

function validateKuery(query) {
  try {
    (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query));
  } catch (e) {
    return _i18n.i18n.translate('xpack.triggersActionsUI.data.coreQueryParams.invalidKQLQueryErrorMessage', {
      defaultMessage: 'Filter query is invalid.'
    });
  }
}