"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentileFields = exports.default = exports.RulesList = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _ebtTools = require("@kbn/ebt-tools");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../../../../types");
var _bulk_operation_popover = require("../../common/components/bulk_operation_popover");
var _rule_quick_edit_buttons = require("../../common/components/rule_quick_edit_buttons");
var _collapsed_item_actions = require("./collapsed_item_actions");
var _rules_list_filters_bar = require("./rules_list_filters_bar");
var _bulk_delete = require("../../../lib/rule_api/bulk_delete");
var _bulk_disable = require("../../../lib/rule_api/bulk_disable");
var _bulk_enable = require("../../../lib/rule_api/bulk_enable");
var _clone = require("../../../lib/rule_api/clone");
var _snooze = require("../../../lib/rule_api/snooze");
var _unsnooze = require("../../../lib/rule_api/unsnooze");
var _update_api_key = require("../../../lib/rule_api/update_api_key");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _rules_delete_modal_confirmation = require("../../../components/rules_delete_modal_confirmation");
var _update_api_key_modal_confirmation = require("../../../components/update_api_key_modal_confirmation");
var _constants = require("../../../constants");
var _use_bulk_edit_select = require("../../../hooks/use_bulk_edit_select");
var _capabilities = require("../../../lib/capabilities");
var _run_rule = require("../../../lib/run_rule");
var _translations = require("../translations");
var _bulk_snooze_modal = require("./bulk_snooze_modal");
var _bulk_snooze_schedule_modal = require("./bulk_snooze_schedule_modal");
var _create_rule_button = require("./create_rule_button");
var _manage_license_modal = require("./manage_license_modal");
var _rules_list_clear_rule_filter_banner = require("./rules_list_clear_rule_filter_banner");
var _rules_list_doc_link = require("./rules_list_doc_link");
var _rules_list_prompts = require("./rules_list_prompts");
var _rules_list_table = require("./rules_list_table");
var _toast_with_circuit_breaker_content = require("../../../components/toast_with_circuit_breaker_content");
var _use_load_action_types_query = require("../../../hooks/use_load_action_types_query");
var _use_load_config_query = require("../../../hooks/use_load_config_query");
var _use_load_rule_aggregations_query = require("../../../hooks/use_load_rule_aggregations_query");
var _use_load_rules_query = require("../../../hooks/use_load_rules_query");
var _rules_settings_link = require("../../../components/rules_setting/rules_settings_link");
var _use_bulk_operation_toast = require("../../../hooks/use_bulk_operation_toast");
var _use_rules_list_ui_state = require("../../../hooks/use_rules_list_ui_state");
var _use_rules_list_filter_store = require("./hooks/use_rules_list_filter_store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rules_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable react-hooks/exhaustive-deps */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const percentileFields = exports.percentileFields = {
  [_types.Percentiles.P50]: 'monitoring.run.calculated_metrics.p50',
  [_types.Percentiles.P95]: 'monitoring.run.calculated_metrics.p95',
  [_types.Percentiles.P99]: 'monitoring.run.calculated_metrics.p99'
};
const initialPercentileOptions = Object.values(_types.Percentiles).map(percentile => ({
  checked: percentile === _types.Percentiles.P50 ? 'on' : undefined,
  label: percentile,
  key: percentile
}));
const EMPTY_ARRAY = [];
const RulesList = ({
  ruleTypeIds,
  consumers,
  filteredRuleTypes = EMPTY_ARRAY,
  lastResponseFilter,
  lastRunOutcomeFilter,
  refresh,
  ruleDetailsRoute,
  ruleParamFilter,
  rulesListKey,
  searchFilter = '',
  showActionFilter = true,
  showCreateRuleButtonInPrompt = false,
  showSearchBar = true,
  statusFilter,
  typeFilter,
  visibleColumns,
  onLastResponseFilterChange,
  onLastRunOutcomeFilterChange,
  onRuleParamFilterChange,
  onSearchFilterChange,
  onStatusFilterChange,
  onTypeFilterChange,
  onRefresh,
  setHeaderActions,
  navigateToEditRuleForm
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const kibanaServices = (0, _kibana.useKibana)().services;
  const {
    actionTypeRegistry,
    application: {
      capabilities,
      navigateToApp
    },
    http,
    kibanaFeatures,
    notifications: {
      toasts
    },
    ruleTypeRegistry,
    ...startServices
  } = kibanaServices;
  const canExecuteActions = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const [isPerformingAction, setIsPerformingAction] = (0, _react.useState)(false);
  const [page, setPage] = (0, _react.useState)({
    index: 0,
    size: _constants.DEFAULT_SEARCH_PAGE_SIZE
  });
  const [inputText, setInputText] = (0, _react.useState)(searchFilter);
  const [ruleTypeModalVisible, setRuleTypeModalVisibility] = (0, _react.useState)(false);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [showErrors, setShowErrors] = (0, _react.useState)(false);
  const cloneRuleId = (0, _react.useRef)(null);
  const isRuleStatusFilterEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleStatusFilter');
  const [percentileOptions, setPercentileOptions] = (0, _react.useState)(initialPercentileOptions);
  const [sort, setSort] = (0, _react.useState)({
    field: 'name',
    direction: 'asc'
  });
  const [manageLicenseModalOpts, setManageLicenseModalOpts] = (0, _react.useState)(null);
  const [isEnablingRules, setIsEnablingRules] = (0, _react.useState)(false);
  const [isDisablingRules, setIsDisablingRules] = (0, _react.useState)(false);
  const [rulesToBulkEdit, setRulesToBulkEdit] = (0, _react.useState)([]);
  const [rulesToBulkEditFilter, setRulesToBulkEditFilter] = (0, _react.useState)();
  const [bulkEditAction, setBulkEditAction] = (0, _react.useState)();
  const [isBulkEditing, setIsBulkEditing] = (0, _react.useState)(false);
  const [isCloningRule, setIsCloningRule] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [localRefresh, setLocalRefresh] = (0, _react.useState)(new Date());

  // Fetch config
  const {
    config
  } = (0, _use_load_config_query.useLoadConfigQuery)();
  // Fetch rule types
  const {
    ruleTypesState,
    hasAnyAuthorizedRuleType,
    authorizedRuleTypes,
    authorizedToReadAnyRules,
    authorizedToCreateAnyRules,
    isSuccess: isLoadRuleTypesSuccess
  } = (0, _alertsUiShared.useGetRuleTypesPermissions)({
    http,
    toasts,
    filteredRuleTypes
  });
  // Fetch action types
  const {
    actionTypes
  } = (0, _use_load_action_types_query.useLoadActionTypesQuery)();
  const {
    filters,
    setFiltersStore,
    numberOfFiltersStore,
    resetFiltersStore
  } = (0, _use_rules_list_filter_store.useRulesListFilterStore)({
    lastResponseFilter,
    lastRunOutcomeFilter,
    rulesListKey,
    ruleParamFilter,
    statusFilter,
    searchFilter,
    typeFilter
  });
  const rulesTypesFilter = (0, _lodash.isEmpty)(filters.types) ? authorizedRuleTypes.map(art => art.id) : filters.types;
  const hasDefaultRuleTypesFiltersOn = (0, _lodash.isEmpty)(filters.types);
  const computedFilter = (0, _react.useMemo)(() => {
    return {
      ...filters,
      types: rulesTypesFilter
    };
  }, [filters, rulesTypesFilter]);
  const canLoadRules = isLoadRuleTypesSuccess && hasAnyAuthorizedRuleType;

  // Fetch rules
  const {
    rulesState,
    loadRules,
    hasData,
    lastUpdate
  } = (0, _use_load_rules_query.useLoadRulesQuery)({
    ruleTypeIds,
    consumers,
    filters: computedFilter,
    hasDefaultRuleTypesFiltersOn,
    page,
    sort,
    onPage: setPage,
    enabled: canLoadRules,
    refresh
  });

  // Fetch status aggregation
  const {
    loadRuleAggregations,
    rulesStatusesTotal,
    rulesLastRunOutcomesTotal
  } = (0, _use_load_rule_aggregations_query.useLoadRuleAggregationsQuery)({
    ruleTypeIds,
    consumers,
    filters: computedFilter,
    enabled: canLoadRules,
    refresh
  });
  const {
    showSpinner,
    showRulesList,
    showNoAuthPrompt,
    showCreateFirstRulePrompt
  } = (0, _use_rules_list_ui_state.useRulesListUiState)({
    authorizedToReadAnyRules,
    authorizedToCreateAnyRules,
    filters,
    hasDefaultRuleTypesFiltersOn,
    isLoadingRuleTypes: ruleTypesState.isLoading,
    isLoadingRules: rulesState.isLoading,
    hasData,
    isInitialLoadingRuleTypes: ruleTypesState.isInitialLoad,
    isInitialLoadingRules: rulesState.initialLoad
  });
  const onRuleEdit = ruleItem => {
    if (navigateToEditRuleForm) {
      navigateToEditRuleForm(ruleItem.id);
      return;
    }
    navigateToApp('management', {
      path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getEditRuleRoute)(ruleItem.id)}`,
      state: {
        returnApp: 'management',
        returnPath: `insightsAndAlerting/triggersActions/rules`
      }
    });
  };
  const onRunRule = async id => {
    await (0, _run_rule.runRule)(http, toasts, id);
  };
  const isRuleTypeEditableInContext = ruleTypeId => ruleTypeRegistry.has(ruleTypeId) ? !ruleTypeRegistry.get(ruleTypeId).requiresAppContext : false;
  const refreshRules = (0, _react.useCallback)(async () => {
    if (!ruleTypesState || !hasAnyAuthorizedRuleType) {
      return;
    }
    const now = new Date();
    setLocalRefresh(now);
    onRefresh === null || onRefresh === void 0 ? void 0 : onRefresh(now);
    await loadRules();
    await loadRuleAggregations();
  }, [loadRules, loadRuleAggregations, setLocalRefresh, onRefresh, isRuleStatusFilterEnabled, hasAnyAuthorizedRuleType, ruleTypesState]);
  const tableItems = (0, _react.useMemo)(() => {
    if (ruleTypesState.isInitialLoad) {
      return [];
    }
    return (0, _rules_list_table.convertRulesToTableItems)({
      rules: rulesState.data,
      ruleTypeIndex: ruleTypesState.data,
      canExecuteActions,
      config
    });
  }, [ruleTypesState, rulesState.data, canExecuteActions, config]);
  const {
    isAllSelected,
    selectedIds,
    isPageSelected,
    numberOfSelectedItems,
    isRowSelected,
    getFilter,
    onSelectRow,
    onSelectAll,
    onSelectPage,
    onClearSelection
  } = (0, _use_bulk_edit_select.useBulkEditSelect)({
    totalItemCount: rulesState.totalItemCount,
    items: tableItems,
    filters: {
      ...filters,
      types: rulesTypesFilter
    }
  });
  const handleUpdateFiltersEffect = (0, _react.useCallback)(updateFilterProps => {
    const {
      filter,
      value
    } = updateFilterProps;
    onClearSelection();
    switch (filter) {
      case 'ruleStatuses':
        onStatusFilterChange === null || onStatusFilterChange === void 0 ? void 0 : onStatusFilterChange(value);
        break;
      case 'ruleExecutionStatuses':
        onLastResponseFilterChange === null || onLastResponseFilterChange === void 0 ? void 0 : onLastResponseFilterChange(value);
        break;
      case 'ruleLastRunOutcomes':
        onLastRunOutcomeFilterChange === null || onLastRunOutcomeFilterChange === void 0 ? void 0 : onLastRunOutcomeFilterChange(value);
        break;
      case 'ruleParams':
        onRuleParamFilterChange === null || onRuleParamFilterChange === void 0 ? void 0 : onRuleParamFilterChange(value);
        break;
      case 'searchText':
        onSearchFilterChange === null || onSearchFilterChange === void 0 ? void 0 : onSearchFilterChange(value);
        break;
      case 'types':
        onTypeFilterChange === null || onTypeFilterChange === void 0 ? void 0 : onTypeFilterChange(value);
        break;
      default:
        break;
    }
  }, [onStatusFilterChange, onLastResponseFilterChange, onLastRunOutcomeFilterChange, onSearchFilterChange, onTypeFilterChange, onClearSelection]);
  const updateFilters = (0, _react.useCallback)(updateFiltersProps => {
    setFiltersStore(updateFiltersProps);
    handleUpdateFiltersEffect(updateFiltersProps);
  }, [setFiltersStore, handleUpdateFiltersEffect]);
  const handleClearRuleParamFilter = () => updateFilters({
    filter: 'ruleParams',
    value: {}
  });
  (0, _ebtTools.usePageReady)({
    isReady: !(rulesState !== null && rulesState !== void 0 && rulesState.initialLoad),
    isRefreshing: rulesState === null || rulesState === void 0 ? void 0 : rulesState.isLoading,
    meta: {
      description: '[ttfmp_rules_list] The Rules List overview page has loaded successfully.'
    }
  });
  (0, _react.useEffect)(() => {
    if (statusFilter) {
      updateFilters({
        filter: 'ruleStatuses',
        value: statusFilter
      });
    }
  }, [statusFilter]);
  (0, _react.useEffect)(() => {
    if (lastResponseFilter) {
      updateFilters({
        filter: 'ruleExecutionStatuses',
        value: lastResponseFilter
      });
    }
  }, [lastResponseFilter]);
  (0, _react.useEffect)(() => {
    if (lastRunOutcomeFilter) {
      updateFilters({
        filter: 'ruleLastRunOutcomes',
        value: lastRunOutcomeFilter
      });
    }
  }, [lastRunOutcomeFilter]);
  (0, _react.useEffect)(() => {
    if (ruleParamFilter && !(0, _lodash.isEqual)(ruleParamFilter, filters.ruleParams)) {
      updateFilters({
        filter: 'ruleParams',
        value: ruleParamFilter
      });
    }
  }, [ruleParamFilter]);
  (0, _react.useEffect)(() => {
    if (typeof searchFilter === 'string') {
      updateFilters({
        filter: 'searchText',
        value: searchFilter
      });
    }
  }, [searchFilter]);
  (0, _react.useEffect)(() => {
    if (typeFilter) {
      updateFilters({
        filter: 'types',
        value: typeFilter
      });
    }
  }, [typeFilter]);
  (0, _react.useEffect)(() => {
    if (cloneRuleId.current) {
      const ruleItem = tableItems.find(ti => ti.id === cloneRuleId.current);
      cloneRuleId.current = null;
      setIsCloningRule(false);
      if (ruleItem) {
        onRuleEdit(ruleItem);
      }
    }
  }, [tableItems]);
  const buildErrorListItems = _executionStatus => {
    var _executionStatus$erro, _executionStatus$erro2;
    const hasErrorMessage = _executionStatus.status === 'error';
    const errorMessage = _executionStatus === null || _executionStatus === void 0 ? void 0 : (_executionStatus$erro = _executionStatus.error) === null || _executionStatus$erro === void 0 ? void 0 : _executionStatus$erro.message;
    const isLicenseError = ((_executionStatus$erro2 = _executionStatus.error) === null || _executionStatus$erro2 === void 0 ? void 0 : _executionStatus$erro2.reason) === _common.RuleExecutionStatusErrorReasons.License;
    const statusMessage = isLicenseError ? _translations.ALERT_STATUS_LICENSE_ERROR : null;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.rulesList.expandRow.title",
        defaultMessage: "Error from last run",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 481,
          columnNumber: 11
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorMessage, hasErrorMessage && statusMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 489,
          columnNumber: 50
        }
      }), statusMessage)
    }];
  };
  const toggleErrorMessage = (_executionStatus, ruleItem) => {
    setItemIdToExpandedRowMap(itemToExpand => {
      const _itemToExpand = {
        ...itemToExpand
      };
      if (_itemToExpand[ruleItem.id]) {
        delete _itemToExpand[ruleItem.id];
      } else {
        _itemToExpand[ruleItem.id] = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          listItems: buildErrorListItems(_executionStatus),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 504,
            columnNumber: 11
          }
        });
      }
      return _itemToExpand;
    });
  };
  const toggleRuleErrors = (0, _react.useCallback)(() => {
    setShowErrors(prevValue => {
      if (!prevValue) {
        const rulesToExpand = rulesState.data.reduce((acc, ruleItem) => {
          var _ruleItem$lastRun;
          // Check both outcome and executionStatus for now until we deprecate executionStatus
          if (((_ruleItem$lastRun = ruleItem.lastRun) === null || _ruleItem$lastRun === void 0 ? void 0 : _ruleItem$lastRun.outcome) === _common.RuleLastRunOutcomeValues[2] || ruleItem.executionStatus.status === 'error') {
            return {
              ...acc,
              [ruleItem.id]: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
                listItems: buildErrorListItems(ruleItem.executionStatus),
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 523,
                  columnNumber: 17
                }
              })
            };
          }
          return acc;
        }, {});
        setItemIdToExpandedRowMap(rulesToExpand);
      } else {
        setItemIdToExpandedRowMap({});
      }
      return !prevValue;
    });
  }, [showErrors, rulesState]);
  const getProducerFeatureName = producer => {
    var _kibanaFeatures$find;
    return kibanaFeatures === null || kibanaFeatures === void 0 ? void 0 : (_kibanaFeatures$find = kibanaFeatures.find(featureItem => featureItem.id === producer)) === null || _kibanaFeatures$find === void 0 ? void 0 : _kibanaFeatures$find.name;
  };
  const groupRuleTypesByProducer = () => {
    return authorizedRuleTypes.reduce((result, ruleType) => {
      const producer = ruleType.producer;
      (result[producer] = result[producer] || []).push({
        value: ruleType.id,
        name: ruleType.name
      });
      return result;
    }, {});
  };
  const onDisableRule = (0, _react.useCallback)((rule, untrack) => {
    return (0, _bulk_disable.bulkDisableRules)({
      http,
      ids: [rule.id],
      untrack
    });
  }, [_bulk_disable.bulkDisableRules]);
  const onEnableRule = (0, _react.useCallback)(rule => {
    return (0, _bulk_enable.bulkEnableRules)({
      http,
      ids: [rule.id]
    });
  }, [_bulk_enable.bulkEnableRules]);
  const onSnoozeRule = (rule, snoozeSchedule) => {
    return (0, _snooze.snoozeRule)({
      http,
      id: rule.id,
      snoozeSchedule
    });
  };
  const onUnsnoozeRule = (rule, scheduleIds) => {
    return (0, _unsnooze.unsnoozeRule)({
      http,
      id: rule.id,
      scheduleIds
    });
  };
  const onSearchPopulate = value => {
    setInputText(value);
    updateFilters({
      filter: 'searchText',
      value
    });
  };
  const filterOptions = (0, _lodash.sortBy)(Object.entries(groupRuleTypesByProducer())).map(([groupName, ruleTypesOptions]) => {
    var _getProducerFeatureNa;
    return {
      groupName: (_getProducerFeatureNa = getProducerFeatureName(groupName)) !== null && _getProducerFeatureNa !== void 0 ? _getProducerFeatureNa : (0, _lodash.capitalize)(groupName),
      subOptions: ruleTypesOptions.sort((a, b) => a.name.localeCompare(b.name))
    };
  });
  const authorizedToModifySelectedRules = (0, _react.useMemo)(() => {
    if (isAllSelected) {
      return true;
    }
    return selectedIds.length ? filterRulesById(rulesState.data, selectedIds).every(selectedRule => (0, _capabilities.hasAllPrivilege)(selectedRule.consumer, ruleTypesState.data.get(selectedRule.ruleTypeId))) : false;
  }, [selectedIds, rulesState.data, ruleTypesState.data, isAllSelected]);
  const updateRulesToBulkEdit = (0, _react.useCallback)(({
    action,
    rules,
    filter
  }) => {
    setBulkEditAction(action);
    if (rules) {
      setRulesToBulkEdit(rules);
    }
    if (filter) {
      setRulesToBulkEditFilter(filter);
    }
    if (action === 'delete') {
      setIsDeleteModalVisibility(rules && rules.length > 0 || Boolean(filter));
    }
  }, []);
  const clearRulesToBulkEdit = (0, _react.useCallback)(() => {
    if (bulkEditAction === 'delete') {
      setIsDeleteModalVisibility(false);
    }
    setRulesToBulkEdit([]);
    setRulesToBulkEditFilter(undefined);
    setBulkEditAction(undefined);
  }, []);
  const isRulesTableLoading = isLoading || rulesState.isLoading || ruleTypesState.isLoading || isBulkEditing || isPerformingAction || isEnablingRules || isDisablingRules || isCloningRule;
  const onCloneRule = async ruleId => {
    setIsCloningRule(true);
    try {
      const RuleCloned = await (0, _clone.cloneRule)({
        http,
        ruleId
      });
      cloneRuleId.current = RuleCloned.id;
      await loadRules();
    } catch {
      cloneRuleId.current = null;
      setIsCloningRule(false);
      toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.cloneFailed', {
        defaultMessage: 'Unable to clone rule'
      }));
    }
  };
  const openRuleTypeModal = (0, _react.useCallback)(() => {
    setRuleTypeModalVisibility(true);
  }, []);
  (0, _react.useEffect)(() => {
    setHeaderActions === null || setHeaderActions === void 0 ? void 0 : setHeaderActions([...(authorizedToCreateAnyRules ? [/*#__PURE__*/_react.default.createElement(_create_rule_button.CreateRuleButton, {
      openFlyout: openRuleTypeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 668,
        columnNumber: 41
      }
    })] : []), /*#__PURE__*/_react.default.createElement(_rules_settings_link.RulesSettingsLink, {
      alertDeleteCategoryIds: ['management', 'observability', 'securitySolution'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 669,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_list_doc_link.RulesListDocLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 672,
        columnNumber: 7
      }
    })]);
  }, [authorizedToCreateAnyRules]);
  (0, _react.useEffect)(() => {
    return () => setHeaderActions === null || setHeaderActions === void 0 ? void 0 : setHeaderActions();
  }, []);
  const [isDeleteModalFlyoutVisible, setIsDeleteModalVisibility] = (0, _react.useState)(false);
  const {
    showToast
  } = (0, _use_bulk_operation_toast.useBulkOperationToast)({
    onSearchPopulate
  });
  const onEnable = async () => {
    setIsEnablingRules(true);
    const {
      errors,
      total
    } = isAllSelected ? await (0, _bulk_enable.bulkEnableRules)({
      http,
      filter: getFilter()
    }) : await (0, _bulk_enable.bulkEnableRules)({
      http,
      ids: selectedIds
    });
    setIsEnablingRules(false);
    const circuitBreakerError = errors.find(error => !!(0, _common.parseRuleCircuitBreakerErrorMessage)(error.message).details);
    if (circuitBreakerError) {
      const parsedError = (0, _common.parseRuleCircuitBreakerErrorMessage)(circuitBreakerError.message);
      toasts.addDanger({
        title: parsedError.summary,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_toast_with_circuit_breaker_content.ToastWithCircuitBreakerContent, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 702,
            columnNumber: 11
          }
        }, parsedError.details), startServices)
      });
    } else {
      showToast({
        action: 'ENABLE',
        errors,
        total
      });
    }
    await refreshRules();
    onClearSelection();
  };
  const onDisable = async untrack => {
    setIsDisablingRules(true);
    const {
      errors,
      total
    } = isAllSelected ? await (0, _bulk_disable.bulkDisableRules)({
      http,
      filter: getFilter(),
      untrack
    }) : await (0, _bulk_disable.bulkDisableRules)({
      http,
      ids: selectedIds,
      untrack
    });
    setIsDisablingRules(false);
    showToast({
      action: 'DISABLE',
      errors,
      total
    });
    await refreshRules();
    onClearSelection();
  };
  const onDeleteCancel = () => {
    setIsDeleteModalVisibility(false);
    clearRulesToBulkEdit();
  };
  const onDeleteConfirm = async () => {
    if (bulkEditAction !== 'delete') {
      return;
    }
    setIsDeleteModalVisibility(false);
    setIsBulkEditing(true);
    const bulkDeleteRulesArguments = isAllSelected && rulesToBulkEditFilter ? {
      filter: rulesToBulkEditFilter,
      http
    } : {
      ids: rulesToBulkEdit.map(rule => rule.id),
      http
    };
    const {
      errors,
      total
    } = await (0, _bulk_delete.bulkDeleteRules)(bulkDeleteRulesArguments);
    setIsBulkEditing(false);
    showToast({
      action: 'DELETE',
      errors,
      total
    });
    clearRulesToBulkEdit();
    onClearSelection();
    refreshRules();
  };
  const numberRulesToDelete = rulesToBulkEdit.length || numberOfSelectedItems;
  const allRuleCategories = getAllUniqueRuleTypeCategories(Array.from(ruleTypesState.data.values()));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showSearchBar && !(0, _lodash.isEmpty)(filters.ruleParams) ? /*#__PURE__*/_react.default.createElement(_rules_list_clear_rule_filter_banner.RulesListClearRuleFilterBanner, {
    onClickClearFilter: handleClearRuleParamFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 766,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_alertsUiShared.MaintenanceWindowCallout, {
    kibanaServices: kibanaServices,
    categories: allRuleCategories,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 768,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 769,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_list_prompts.RulesListPrompts, {
    showNoAuthPrompt: showNoAuthPrompt,
    showCreateFirstRulePrompt: showCreateFirstRulePrompt,
    showCreateRuleButtonInPrompt: showCreateRuleButtonInPrompt,
    showSpinner: showSpinner,
    onCreateRulesClick: openRuleTypeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 770,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "rulesList",
    grow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 777,
      columnNumber: 7
    }
  }, isDeleteModalFlyoutVisible && /*#__PURE__*/_react.default.createElement(_rules_delete_modal_confirmation.RulesDeleteModalConfirmation, {
    onConfirm: onDeleteConfirm,
    onCancel: onDeleteCancel,
    confirmButtonText: (0, _translations.getConfirmDeletionButtonText)(numberRulesToDelete, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
    confirmModalText: (0, _translations.getConfirmDeletionModalText)(numberRulesToDelete, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
    showWarningText: isAllSelected,
    warningText: (0, _translations.getConfirmDeletionModalWarningText)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 779,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_bulk_snooze_modal.BulkSnoozeModalWithApi, {
    rules: rulesToBulkEdit,
    filter: rulesToBulkEditFilter,
    bulkEditAction: bulkEditAction,
    numberOfSelectedRules: numberOfSelectedItems,
    setIsBulkEditing: setIsBulkEditing,
    onClose: () => {
      // Don't clear the bulk edit action yet since we need it for loading indicator
      setRulesToBulkEdit([]);
      setRulesToBulkEditFilter(undefined);
    },
    onSave: async () => {
      clearRulesToBulkEdit();
      onClearSelection();
      await refreshRules();
    },
    onSearchPopulate: onSearchPopulate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 796,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_bulk_snooze_schedule_modal.BulkSnoozeScheduleModalWithApi, {
    rules: rulesToBulkEdit,
    filter: rulesToBulkEditFilter,
    bulkEditAction: bulkEditAction,
    numberOfSelectedRules: numberOfSelectedItems,
    setIsBulkEditing: setIsBulkEditing,
    onClose: () => {
      // Don't clear the bulk edit action yet since we need it for loading indicator
      setRulesToBulkEdit([]);
      setRulesToBulkEditFilter(undefined);
    },
    onSave: async () => {
      clearRulesToBulkEdit();
      onClearSelection();
      await refreshRules();
    },
    onSearchPopulate: onSearchPopulate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 814,
      columnNumber: 9
    }
  }), bulkEditAction === 'updateApiKey' && /*#__PURE__*/_react.default.createElement(_update_api_key_modal_confirmation.UpdateApiKeyModalConfirmation, {
    onCancel: () => {
      clearRulesToBulkEdit();
    },
    rulesToUpdate: rulesToBulkEdit,
    idsToUpdateFilter: rulesToBulkEditFilter,
    numberOfSelectedRules: numberOfSelectedItems,
    apiUpdateApiKeyCall: _update_api_key.bulkUpdateAPIKey,
    setIsLoadingState: newIsLoading => {
      setIsBulkEditing(newIsLoading);
      setIsLoading(newIsLoading);
    },
    onUpdated: async () => {
      clearRulesToBulkEdit();
      onClearSelection();
      await refreshRules();
    },
    onSearchPopulate: onSearchPopulate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 833,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 853,
      columnNumber: 9
    }
  }), showRulesList && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showSearchBar ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rules_list_filters_bar.RulesListFiltersBar, {
    actionTypes: actionTypes,
    filterOptions: filterOptions,
    filters: filters,
    inputText: inputText,
    lastUpdate: lastUpdate,
    rulesLastRunOutcomesTotal: rulesLastRunOutcomesTotal,
    rulesStatusesTotal: rulesStatusesTotal,
    setInputText: setInputText,
    showActionFilter: showActionFilter,
    showErrors: showErrors,
    canLoadRules: canLoadRules,
    refresh: refresh || localRefresh,
    updateFilters: updateFilters,
    onClearSelection: onClearSelection,
    onRefreshRules: refreshRules,
    onToggleRuleErrors: toggleRuleErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 859,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 877,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_rules_list_table.RulesListTable, {
    items: tableItems,
    isLoading: isRulesTableLoading,
    rulesState: rulesState,
    ruleTypesState: ruleTypesState,
    ruleTypeRegistry: ruleTypeRegistry,
    isPageSelected: isPageSelected,
    isAllSelected: isAllSelected,
    numberOfSelectedRules: numberOfSelectedItems,
    sort: sort,
    page: page,
    percentileOptions: percentileOptions,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    onSort: setSort,
    onPage: setPage,
    onRuleChanged: refreshRules,
    onRuleClick: rule => {
      const detailsRoute = ruleDetailsRoute ? ruleDetailsRoute : _ruleDataUtils.ruleDetailsRoute;
      history.push(detailsRoute.replace(`:ruleId`, rule.id));
    },
    onRuleEditClick: rule => {
      if (rule.isEditable && isRuleTypeEditableInContext(rule.ruleTypeId)) {
        onRuleEdit(rule);
      }
    },
    onRuleDeleteClick: rule => updateRulesToBulkEdit({
      action: 'delete',
      rules: [rule]
    }),
    onManageLicenseClick: rule => {
      var _ruleTypesState$data$;
      return setManageLicenseModalOpts({
        licenseType: (_ruleTypesState$data$ = ruleTypesState.data.get(rule.ruleTypeId)) === null || _ruleTypesState$data$ === void 0 ? void 0 : _ruleTypesState$data$.minimumLicenseRequired,
        ruleTypeId: rule.ruleTypeId
      });
    },
    onPercentileOptionsChange: setPercentileOptions,
    onDisableRule: onDisableRule,
    onEnableRule: onEnableRule,
    onSnoozeRule: onSnoozeRule,
    onUnsnoozeRule: onUnsnoozeRule,
    onSelectAll: onSelectAll,
    onSelectPage: onSelectPage,
    onSelectRow: onSelectRow,
    isRowSelected: isRowSelected,
    renderCollapsedItemActions: (rule, onLoading) => /*#__PURE__*/_react.default.createElement(_collapsed_item_actions.CollapsedItemActionsWithApi, {
      key: rule.id,
      item: rule,
      onLoading: onLoading,
      onRuleChanged: refreshRules,
      onDeleteRule: () => updateRulesToBulkEdit({
        action: 'delete',
        rules: [rule]
      }),
      onEditRule: () => onRuleEdit(rule),
      onUpdateAPIKey: () => updateRulesToBulkEdit({
        action: 'updateApiKey',
        rules: [rule]
      }),
      onRunRule: () => onRunRule(rule.id),
      onCloneRule: onCloneRule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 928,
        columnNumber: 17
      }
    }),
    renderRuleError: rule => {
      var _executionStatus$erro3;
      const _executionStatus = rule.executionStatus;
      const hasErrorMessage = _executionStatus.status === 'error';
      const isLicenseError = ((_executionStatus$erro3 = _executionStatus.error) === null || _executionStatus$erro3 === void 0 ? void 0 : _executionStatus$erro3.reason) === _common.RuleExecutionStatusErrorReasons.License;
      return isLicenseError || hasErrorMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleErrorMessage(_executionStatus, rule),
        "aria-label": itemIdToExpandedRowMap[rule.id] ? 'Collapse' : 'Expand',
        iconType: itemIdToExpandedRowMap[rule.id] ? 'arrowUp' : 'arrowDown',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 957,
          columnNumber: 19
        }
      }) : null;
    },
    renderSelectAllDropdown: () => {
      return /*#__PURE__*/_react.default.createElement(_bulk_operation_popover.BulkOperationPopover, {
        numberOfSelectedRules: numberOfSelectedItems,
        canModifySelectedRules: authorizedToModifySelectedRules,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 966,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_quick_edit_buttons.RuleQuickEditButtonsWithApi, {
        selectedItems: (0, _rules_list_table.convertRulesToTableItems)({
          rules: filterRulesById(rulesState.data, selectedIds),
          ruleTypeIndex: ruleTypesState.data,
          canExecuteActions,
          config
        }),
        isBulkEditing: isBulkEditing,
        bulkEditAction: bulkEditAction,
        updateRulesToBulkEdit: updateRulesToBulkEdit,
        isAllSelected: isAllSelected,
        getFilter: getFilter,
        onPerformingAction: () => setIsPerformingAction(true),
        onActionPerformed: () => {
          refreshRules();
          setIsPerformingAction(false);
        },
        isEnablingRules: isEnablingRules,
        isDisablingRules: isDisablingRules,
        onEnable: onEnable,
        onDisable: onDisable,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 970,
          columnNumber: 21
        }
      }));
    },
    rulesListKey: rulesListKey,
    config: config,
    visibleColumns: visibleColumns,
    numberOfFilters: numberOfFiltersStore,
    resetFilters: resetFiltersStore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 881,
      columnNumber: 13
    }
  }), manageLicenseModalOpts && /*#__PURE__*/_react.default.createElement(_manage_license_modal.ManageLicenseModal, {
    licenseType: manageLicenseModalOpts.licenseType,
    ruleTypeId: manageLicenseModalOpts.ruleTypeId,
    onConfirm: () => {
      window.open(`${http.basePath.get()}/app/management/stack/license_management`, '_blank');
      setManageLicenseModalOpts(null);
    },
    onCancel: () => setManageLicenseModalOpts(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1002,
      columnNumber: 15
    }
  })), ruleTypeModalVisible && /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleTypeModal, {
    onClose: () => setRuleTypeModalVisibility(false),
    onSelectRuleType: ruleTypeId => {
      navigateToApp('management', {
        path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getCreateRuleRoute)(ruleTypeId)}`
      });
    },
    http: http,
    toasts: toasts,
    registeredRuleTypes: ruleTypeRegistry.list(),
    filteredRuleTypes: filteredRuleTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1018,
      columnNumber: 11
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RulesList = RulesList;
function filterRulesById(rules, ids) {
  return rules.filter(rule => ids.includes(rule.id));
}
const getAllUniqueRuleTypeCategories = ruleTypes => {
  const categories = new Set(ruleTypes.map(ruleType => ruleType.category));
  return Array.from(categories).filter(Boolean);
};