"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.futureTimeToInterval = exports.default = exports.RuleStatusDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _common = require("@kbn/alerting-plugin/common");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _rule_snooze = require("./rule_snooze");
var _lib = require("../../../lib");
var _toast_with_circuit_breaker_content = require("../../../components/toast_with_circuit_breaker_content");
var _untrack_alerts_modal = require("../../common/components/untrack_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_status_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SNOOZE_END_TIME_FORMAT = 'LL @ LT';
const RuleStatusDropdown = ({
  rule,
  onRuleChanged,
  disableRule,
  enableRule,
  snoozeRule,
  unsnoozeRule,
  isEditable,
  hideSnoozeOption = false,
  direction = 'column',
  autoRecoverAlerts
}) => {
  const {
    notifications: {
      toasts
    },
    i18n: i18nStart,
    theme,
    userProfile
  } = (0, _kibana.useKibana)().services;
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isUntrackAlertsModalOpen, setIsUntrackAlertsModalOpen] = (0, _react.useState)(false);
  const isSnoozed = !hideSnoozeOption && (0, _lib.isRuleSnoozed)(rule);
  const onClickBadge = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), [setIsPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const enableRuleInternal = (0, _react.useCallback)(async () => {
    const {
      errors
    } = await enableRule();
    if (!errors.length) {
      return;
    }
    const message = (0, _common.parseRuleCircuitBreakerErrorMessage)(errors[0].message);
    toasts.addDanger({
      title: message.summary,
      ...(message.details && {
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_toast_with_circuit_breaker_content.ToastWithCircuitBreakerContent, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 11
          }
        }, message.details), {
          i18n: i18nStart,
          theme,
          userProfile
        })
      })
    });
    throw new Error();
  }, [i18nStart, theme, userProfile, enableRule, toasts]);
  const onEnable = (0, _react.useCallback)(async () => {
    setIsUpdating(true);
    try {
      await enableRuleInternal();
      onRuleChanged();
    } finally {
      setIsUpdating(false);
    }
  }, [onRuleChanged, enableRuleInternal]);
  const onDisable = (0, _react.useCallback)(async untrack => {
    setIsUpdating(true);
    try {
      await disableRule(untrack);
      onRuleChanged();
    } finally {
      setIsUpdating(false);
    }
  }, [onRuleChanged, disableRule]);
  const onDisableModalOpen = (0, _react.useCallback)(() => {
    setIsUntrackAlertsModalOpen(true);
  }, []);
  const onDisableModalClose = (0, _react.useCallback)(() => {
    setIsUntrackAlertsModalOpen(false);
  }, []);
  const onModalConfirm = (0, _react.useCallback)(untrack => {
    onDisableModalClose();
    onDisable(untrack);
  }, [onDisableModalClose, onDisable]);
  const onChangeEnabledStatus = (0, _react.useCallback)(async enable => {
    if (rule.enabled === enable) {
      return;
    }
    if (enable) {
      await onEnable();
    } else if (autoRecoverAlerts === false) {
      onDisable(false);
    } else {
      onDisableModalOpen();
    }
  }, [rule.enabled, autoRecoverAlerts, onEnable, onDisableModalOpen, onDisable]);
  const onSnoozeRule = (0, _react.useCallback)(async snoozeSchedule => {
    try {
      await snoozeRule(snoozeSchedule);
      onRuleChanged();
    } finally {
      onClosePopover();
    }
  }, [snoozeRule, onRuleChanged, onClosePopover]);
  const onUnsnoozeRule = (0, _react.useCallback)(async scheduleIds => {
    try {
      await unsnoozeRule(scheduleIds);
      onRuleChanged();
    } finally {
      onClosePopover();
    }
  }, [unsnoozeRule, onRuleChanged, onClosePopover]);
  const badgeColor = !rule.enabled ? 'default' : isSnoozed ? 'warning' : 'primary';
  const badgeMessage = !rule.enabled ? DISABLED : isSnoozed ? SNOOZED : ENABLED;
  const remainingSnoozeTime = rule.enabled && isSnoozed ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: rule.muteAll ? INDEFINITELY : (0, _moment.default)(new Date(rule.isSnoozedUntil)).format(SNOOZE_END_TIME_FORMAT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, rule.muteAll ? INDEFINITELY : (0, _moment.default)(new Date(rule.isSnoozedUntil)).fromNow(true))) : null;
  const nonEditableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    "data-test-subj": "statusDropdownReadonly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }, badgeMessage);
  const editableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "ruleStatusDropdownBadge",
    color: badgeColor,
    iconSide: "right",
    iconType: !isUpdating && isEditable ? 'arrowDown' : undefined,
    onClick: onClickBadge,
    iconOnClick: onClickBadge,
    onClickAriaLabel: OPEN_MENU_ARIA_LABEL,
    iconOnClickAriaLabel: OPEN_MENU_ARIA_LABEL,
    isDisabled: isUpdating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }, badgeMessage, isUpdating && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    style: {
      marginLeft: '4px',
      marginRight: '4px'
    },
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction,
    alignItems: direction === 'row' ? 'center' : 'flexStart',
    justifyContent: "flexStart",
    gutterSize: direction === 'row' ? 's' : 'xs',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `ruleType_${rule.ruleTypeId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, isEditable ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: editableBadge,
    isOpen: isPopoverOpen && isEditable,
    closePopover: onClosePopover,
    panelPaddingSize: "s",
    "data-test-subj": "statusDropdown",
    title: badgeMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(RuleStatusMenu, {
    onClosePopover: onClosePopover,
    onChangeEnabledStatus: onChangeEnabledStatus,
    isEnabled: rule.enabled,
    isSnoozed: isSnoozed,
    snoozeEndTime: rule.isSnoozedUntil,
    hideSnoozeOption: hideSnoozeOption,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    scheduledSnoozes: rule.snoozeSchedule,
    activeSnoozes: rule.activeSnoozes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  })) : nonEditableBadge), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "remainingSnoozeTime",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, remainingSnoozeTime)), isUntrackAlertsModalOpen && /*#__PURE__*/_react.default.createElement(_untrack_alerts_modal.UntrackAlertsModal, {
    onConfirm: onModalConfirm,
    onCancel: onDisableModalClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  }));
};
exports.default = exports.RuleStatusDropdown = RuleStatusDropdown;
const RuleStatusMenu = ({
  onChangeEnabledStatus,
  onClosePopover,
  isEnabled,
  isSnoozed,
  snoozeEndTime,
  hideSnoozeOption = false,
  snoozeRule,
  unsnoozeRule,
  scheduledSnoozes = [],
  activeSnoozes = []
}) => {
  const enableRule = (0, _react.useCallback)(() => {
    if (isSnoozed) {
      // Unsnooze if the rule is snoozed and the user clicks Enabled
      unsnoozeRule();
    } else {
      onChangeEnabledStatus(true);
    }
    onClosePopover();
  }, [onChangeEnabledStatus, onClosePopover, unsnoozeRule, isSnoozed]);
  const disableRule = (0, _react.useCallback)(() => {
    onChangeEnabledStatus(false);
    onClosePopover();
  }, [onChangeEnabledStatus, onClosePopover]);
  let snoozeButtonTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 27
    }
  }, SNOOZE);
  if (isSnoozed && snoozeEndTime) {
    snoozeButtonTitle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 9
      }
    }, SNOOZE), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 9
      }
    }, (0, _moment.default)(snoozeEndTime).format(SNOOZE_END_TIME_FORMAT)));
  }
  const getSnoozeMenuItem = () => {
    if (!hideSnoozeOption) {
      return [{
        name: snoozeButtonTitle,
        icon: isEnabled && isSnoozed ? 'check' : 'empty',
        panel: 1,
        disabled: !isEnabled,
        'data-test-subj': 'statusDropdownSnoozeItem'
      }];
    }
    return [];
  };
  const getSnoozePanel = () => {
    if (!hideSnoozeOption) {
      return [{
        id: 1,
        width: 400,
        title: SNOOZE,
        content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "none",
          hasShadow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 344,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
          interval: futureTimeToInterval(snoozeEndTime),
          showCancel: isSnoozed,
          snoozeRule: snoozeRule,
          unsnoozeRule: unsnoozeRule,
          scheduledSnoozes: scheduledSnoozes,
          activeSnoozes: activeSnoozes,
          hasTitle: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 345,
            columnNumber: 15
          }
        }))
      }];
    }
    return [];
  };
  const panels = [{
    id: 0,
    width: 360,
    items: [{
      name: ENABLED,
      icon: isEnabled && !isSnoozed ? 'check' : 'empty',
      onClick: enableRule,
      'data-test-subj': 'statusDropdownEnabledItem'
    }, {
      name: DISABLED,
      icon: !isEnabled ? 'check' : 'empty',
      onClick: disableRule,
      'data-test-subj': 'statusDropdownDisabledItem'
    }, ...getSnoozeMenuItem()]
  }, ...getSnoozePanel()];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "ruleStatusMenu",
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 10
    }
  });
};
const futureTimeToInterval = time => {
  if (!time) return;
  const relativeTime = (0, _moment.default)(time).locale('en').fromNow(true);
  const [valueStr, unitStr] = relativeTime.split(' ');
  let value = valueStr === 'a' || valueStr === 'an' ? 1 : parseInt(valueStr, 10);
  let unit;
  switch (unitStr) {
    case 'year':
    case 'years':
      unit = 'M';
      value = value * 12;
      break;
    case 'month':
    case 'months':
      unit = 'M';
      break;
    case 'day':
    case 'days':
      unit = 'd';
      break;
    case 'hour':
    case 'hours':
      unit = 'h';
      break;
    case 'minute':
    case 'minutes':
      unit = 'm';
      break;
  }
  if (!unit) return;
  return `${value}${unit}`;
};
exports.futureTimeToInterval = futureTimeToInterval;
const ENABLED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.enabledRuleStatus', {
  defaultMessage: 'Enabled'
});
const DISABLED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.disabledRuleStatus', {
  defaultMessage: 'Disabled'
});
const SNOOZED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozedRuleStatus', {
  defaultMessage: 'Snoozed'
});
const SNOOZE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.snoozeMenuTitle', {
  defaultMessage: 'Snooze'
});
const OPEN_MENU_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusDropdownMenuLabel', {
  defaultMessage: 'Change rule status or snooze'
});
const INDEFINITELY = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.remainingSnoozeIndefinite', {
  defaultMessage: 'Indefinitely'
});

// eslint-disable-next-line import/no-default-export