"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEnabledSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_enabled_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleEnabledSwitch = ({
  item,
  onRuleChanged,
  disableRule,
  enableRule
}) => {
  const [isEnabled, setIsEnabled] = (0, _react.useState)(!item.enabled);
  (0, _react.useEffect)(() => {
    setIsEnabled(item.enabled);
  }, [item.enabled]);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  return isUpdating ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "enableSpinner",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "enable",
    disabled: !item.isEditable || !item.enabledInLicense,
    compressed: true,
    checked: isEnabled,
    "data-test-subj": "enableSwitch",
    onChange: async () => {
      setIsUpdating(true);
      const enabled = item.enabled;
      if (enabled) {
        await disableRule({
          ...item,
          enabled
        });
      } else {
        await enableRule({
          ...item,
          enabled
        });
      }
      setIsEnabled(!isEnabled);
      setIsUpdating(false);
      onRuleChanged();
    },
    label: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
exports.RuleEnabledSwitch = RuleEnabledSwitch;