"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListNotifyBadgeWithApi = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../common/lib/kibana");
var _unsnooze = require("../../../../lib/rule_api/unsnooze");
var _snooze = require("../../../../lib/rule_api/snooze");
var _notify_badge = require("./notify_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/notify_badge/notify_badge_with_api.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesListNotifyBadgeWithApi = ({
  ruleId,
  snoozeSettings,
  loading,
  disabled,
  showTooltipInline,
  showOnHover,
  onRuleChanged
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const onSnoozeRule = (0, _react.useCallback)(snoozeSchedule => ruleId ? (0, _snooze.snoozeRule)({
    http,
    id: ruleId,
    snoozeSchedule
  }) : Promise.resolve(), [http, ruleId]);
  const onUnsnoozeRule = (0, _react.useCallback)(scheduleIds => ruleId ? (0, _unsnooze.unsnoozeRule)({
    http,
    id: ruleId,
    scheduleIds
  }) : Promise.resolve(), [http, ruleId]);
  return /*#__PURE__*/_react.default.createElement(_notify_badge.RulesListNotifyBadge, {
    snoozeSettings: snoozeSettings,
    loading: loading,
    disabled: disabled,
    onRuleChanged: onRuleChanged,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    showTooltipInline: showTooltipInline,
    showOnHover: showOnHover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.RulesListNotifyBadgeWithApi = RulesListNotifyBadgeWithApi;