"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewInApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _Option = require("fp-ts/Option");
var _pipeable = require("fp-ts/pipeable");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/view_in_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_NAVIGATION = false;
const ViewInApp = ({
  rule
}) => {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    alerting: maybeAlerting
  } = (0, _kibana.useKibana)().services;
  const [ruleNavigation, setRuleNavigation] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (0, _pipeable.pipe)((0, _Option.fromNullable)(maybeAlerting), (0, _Option.fold)(
    /**
     * If the ruleing plugin is disabled,
     * navigation isn't supported
     */
    () => setRuleNavigation(NO_NAVIGATION), ruleing => {
      return ruleing.getNavigation(rule.id).then(nav => nav ? setRuleNavigation(nav) : setRuleNavigation(NO_NAVIGATION)).catch(() => {
        setRuleNavigation(NO_NAVIGATION);
      });
    }));
  }, [rule.id, maybeAlerting]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "ruleDetails-viewInApp",
    isLoading: ruleNavigation === null,
    disabled: !hasNavigation(ruleNavigation),
    iconType: "popout"
  }, getNavigationHandler(ruleNavigation, rule, navigateToUrl, basePath), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.viewRuleInAppButtonLabel",
    defaultMessage: "View in app",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};
exports.ViewInApp = ViewInApp;
function hasNavigation(ruleNavigation) {
  return typeof ruleNavigation === 'string';
}
function getNavigationHandler(ruleNavigation, rule, navigateToUrl, basePath) {
  return hasNavigation(ruleNavigation) ? {
    onClick: () => {
      navigateToUrl(basePath.prepend(ruleNavigation));
    }
  } : {};
}