"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleStatusPanel = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ = require("../..");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _notify_badge = require("../../rules_list/components/notify_badge");
var _use_load_rule_event_logs = require("../../../hooks/use_load_rule_event_logs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_status_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleStatusPanel = ({
  rule,
  bulkEnableRules,
  bulkDisableRules,
  snoozeRule,
  unsnoozeRule,
  requestRefresh,
  isEditable,
  healthColor,
  statusMessage,
  refreshToken,
  autoRecoverAlerts
}) => {
  const [lastNumberOfExecutions, setLastNumberOfExecutions] = (0, _react.useState)(null);
  const isInitialized = (0, _react.useRef)(false);
  const onSnoozeRule = (0, _react.useCallback)(snoozeSchedule => snoozeRule(rule, snoozeSchedule), [rule, snoozeRule]);
  const onUnsnoozeRule = (0, _react.useCallback)(scheduleIds => unsnoozeRule(rule, scheduleIds), [rule, unsnoozeRule]);
  const statusMessageDisplay = (0, _react.useMemo)(() => {
    if (!statusMessage) {
      var _rule$lastRun;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
        titleSize: "xs",
        title: "--",
        description: "",
        isLoading: !((_rule$lastRun = rule.lastRun) !== null && _rule$lastRun !== void 0 && _rule$lastRun.outcome) && !rule.nextRun,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      });
    }
    return statusMessage;
  }, [rule, statusMessage]);
  const {
    data,
    loadEventLogs
  } = (0, _use_load_rule_event_logs.useLoadRuleEventLogs)({
    id: rule.id,
    dateStart: 'now-24h',
    dateEnd: 'now',
    page: 0,
    perPage: 10
  });
  (0, _react.useEffect)(() => {
    if (!data) {
      return;
    }
    setLastNumberOfExecutions(data.total);
  }, [data]);
  const requestRefreshInternal = (0, _react.useCallback)(() => {
    loadEventLogs();
    requestRefresh();
  }, [requestRefresh, loadEventLogs]);
  const onDisableRule = (0, _react.useCallback)(untrack => {
    return bulkDisableRules({
      ids: [rule.id],
      untrack
    });
  }, [bulkDisableRules, rule.id]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadEventLogs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "ruleStatusPanel",
    hasBorder: true,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.rule.statusPanel.ruleIsEnabledDisabledTitle",
    defaultMessage: "Rule is",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_.RuleStatusDropdown, {
    disableRule: onDisableRule,
    enableRule: () => bulkEnableRules({
      ids: [rule.id]
    }),
    snoozeRule: async () => {},
    unsnoozeRule: async () => {},
    rule: rule,
    onRuleChanged: requestRefreshInternal,
    direction: "row",
    isEditable: isEditable,
    hideSnoozeOption: true,
    autoRecoverAlerts: autoRecoverAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "ruleStatus-numberOfExecutions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, lastNumberOfExecutions !== null && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.rule.statusPanel.totalExecutions",
    defaultMessage: "{executions, plural, one {# execution} other {# executions}} in the last 24 hr",
    values: {
      executions: lastNumberOfExecutions
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": `ruleStatus-${rule.executionStatus.status}`,
    titleSize: "m",
    descriptionElement: "strong",
    titleElement: "h5",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": `ruleStatus-${rule.executionStatus.status}`,
      textSize: "m",
      color: healthColor,
      style: {
        fontWeight: 400
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 17
      }
    }, statusMessageDisplay),
    description: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.rulesList.ruleLastExecutionDescription', {
      defaultMessage: `Last response`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, (0, _moment.default)(rule.executionStatus.lastExecutionDate).fromNow())))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_notify_badge.RulesListNotifyBadge, {
    snoozeSettings: rule,
    loading: !rule,
    disabled: !isEditable,
    onRuleChanged: requestRefreshInternal,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    showTooltipInline: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  })));
};
exports.RuleStatusPanel = RuleStatusPanel;
const RuleStatusPanelWithApi = exports.default = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleStatusPanel);

// eslint-disable-next-line import/no-default-export