"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEventLogListKPIWithApi = exports.RuleEventLogListKPI = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _event_log = require("../../common/components/event_log");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_event_log_list_kpi.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getParsedDate = date => {
  if (date.includes('now')) {
    var _datemath$parse;
    return ((_datemath$parse = _datemath.default.parse(date)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.format()) || date;
  }
  return date;
};
const API_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.ruleEventLogListKpi.apiError', {
  defaultMessage: 'Failed to fetch event log KPI.'
});
const RESPONSE_TOOLTIP = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.ruleEventLogListKpi.responseTooltip', {
  defaultMessage: 'The responses for up to 10,000 most recent rule runs.'
});
const ALERTS_TOOLTIP = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.ruleEventLogListKpi.alertsTooltip', {
  defaultMessage: 'The alert statuses for up to 10,000 most recent rule runs.'
});
const ACTIONS_TOOLTIP = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.ruleEventLogListKpi.actionsTooltip', {
  defaultMessage: 'The action statuses for up to 10,000 most recent rule runs.'
});
const RuleEventLogListKPI = props => {
  var _kpi$success, _kpi$warning, _kpi$failure, _kpi$activeAlerts, _kpi$newAlerts, _kpi$recoveredAlerts, _kpi$erroredActions, _kpi$triggeredActions;
  const {
    ruleId,
    dateStart,
    dateEnd,
    outcomeFilter,
    message,
    refreshToken,
    namespaces,
    filteredRuleTypes,
    loadExecutionKPIAggregations,
    loadGlobalExecutionKPIAggregations
  } = props;
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isInitialized = (0, _react.useRef)(false);
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [kpi, setKpi] = (0, _react.useState)();
  const loadKPIFn = (0, _react.useMemo)(() => {
    if (ruleId === '*') {
      return loadGlobalExecutionKPIAggregations;
    }
    return loadExecutionKPIAggregations;
  }, [ruleId, loadExecutionKPIAggregations, loadGlobalExecutionKPIAggregations]);
  const loadKPIs = async () => {
    setIsLoading(true);
    try {
      const newKpi = await loadKPIFn({
        id: ruleId,
        dateStart: getParsedDate(dateStart),
        dateEnd: getParsedDate(dateEnd),
        outcomeFilter,
        message,
        ...(namespaces ? {
          namespaces
        } : {}),
        ruleTypeIds: filteredRuleTypes
      });
      setKpi(newKpi);
    } catch (e) {
      var _e$body, _e$body$message, _e$body2;
      if (((_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.statusCode) === 413) {
        return;
      }
      toasts.addDanger({
        title: API_FAILED_MESSAGE,
        text: (_e$body$message = (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message) !== null && _e$body$message !== void 0 ? _e$body$message : e
      });
    }
    setIsLoading(false);
  };
  (0, _react.useEffect)(() => {
    loadKPIs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ruleId, dateStart, dateEnd, outcomeFilter, message, namespaces]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadKPIs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  const isLoadingData = (0, _react.useMemo)(() => isLoading || !kpi, [isLoading, kpi]);
  const getStatDescription = element => {
    return /*#__PURE__*/_react.default.createElement("span", {
      style: {
        paddingBottom: '8px',
        display: 'flex'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 12
      }
    }, element);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogStat, {
    title: "Responses",
    tooltip: RESPONSE_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-successOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "success",
      useExecutionStatus: isRuleUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$success = kpi === null || kpi === void 0 ? void 0 : kpi.success) !== null && _kpi$success !== void 0 ? _kpi$success : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-warningOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "warning",
      useExecutionStatus: isRuleUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$warning = kpi === null || kpi === void 0 ? void 0 : kpi.warning) !== null && _kpi$warning !== void 0 ? _kpi$warning : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-failureOutcome",
    description: getStatDescription(/*#__PURE__*/_react.default.createElement(_event_log.EventLogListStatus, {
      status: "failure",
      useExecutionStatus: isRuleUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    })),
    titleSize: "s",
    title: (_kpi$failure = kpi === null || kpi === void 0 ? void 0 : kpi.failure) !== null && _kpi$failure !== void 0 ? _kpi$failure : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogStat, {
    title: "Alerts",
    tooltip: ALERTS_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-activeAlerts",
    description: getStatDescription('Active'),
    titleSize: "s",
    title: (_kpi$activeAlerts = kpi === null || kpi === void 0 ? void 0 : kpi.activeAlerts) !== null && _kpi$activeAlerts !== void 0 ? _kpi$activeAlerts : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-newAlerts",
    description: getStatDescription('New'),
    titleSize: "s",
    title: (_kpi$newAlerts = kpi === null || kpi === void 0 ? void 0 : kpi.newAlerts) !== null && _kpi$newAlerts !== void 0 ? _kpi$newAlerts : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-recoveredAlerts",
    description: getStatDescription('Recovered'),
    titleSize: "s",
    title: (_kpi$recoveredAlerts = kpi === null || kpi === void 0 ? void 0 : kpi.recoveredAlerts) !== null && _kpi$recoveredAlerts !== void 0 ? _kpi$recoveredAlerts : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_event_log.EventLogStat, {
    title: "Actions",
    tooltip: ACTIONS_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-erroredActions",
    description: getStatDescription('Errored'),
    titleSize: "s",
    title: (_kpi$erroredActions = kpi === null || kpi === void 0 ? void 0 : kpi.erroredActions) !== null && _kpi$erroredActions !== void 0 ? _kpi$erroredActions : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "ruleEventLogKpi-triggeredActions",
    description: getStatDescription('Triggered'),
    titleSize: "s",
    title: (_kpi$triggeredActions = kpi === null || kpi === void 0 ? void 0 : kpi.triggeredActions) !== null && _kpi$triggeredActions !== void 0 ? _kpi$triggeredActions : 0,
    isLoading: isLoadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }))))));
};
exports.RuleEventLogListKPI = RuleEventLogListKPI;
const RuleEventLogListKPIWithApi = exports.RuleEventLogListKPIWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleEventLogListKPI);