"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleStats = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _ = require("../../../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alerts_page/hooks/use_rule_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Stat = (0, _styled.default)(_eui.EuiStat)`
  .euiText {
    line-height: 1;
  }
`;
const Divider = _styled.default.div`
  border-right: ${props => props.theme.euiTheme.border.thin};
  height: 100%;
`;
const useRuleStats = ({
  ruleTypeIds,
  consumers
} = {}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _.useKibana)().services;
  const [loading, setLoading] = (0, _react.useState)(false);
  const [stats, setStats] = (0, _react.useState)({
    total: 0,
    disabled: 0,
    muted: 0,
    error: 0,
    snoozed: 0
  });
  const manageRulesHref = (0, _react.useMemo)(() => http.basePath.prepend('/app/management/insightsAndAlerting/triggersActions/rules'), [http.basePath]);
  const loadRuleStats = (0, _react.useCallback)(async () => {
    setLoading(true);
    try {
      const response = await (0, _.loadRuleAggregations)({
        http,
        ruleTypeIds,
        consumers
      });
      const {
        ruleExecutionStatus,
        ruleMutedStatus,
        ruleEnabledStatus,
        ruleSnoozedStatus
      } = response;
      if (ruleExecutionStatus && ruleMutedStatus && ruleEnabledStatus && ruleSnoozedStatus) {
        const total = Object.values(ruleExecutionStatus).reduce((acc, value) => acc + value, 0);
        const {
          disabled
        } = ruleEnabledStatus;
        const {
          muted
        } = ruleMutedStatus;
        const {
          error
        } = ruleExecutionStatus;
        const {
          snoozed
        } = ruleSnoozedStatus;
        setStats(oldStats => ({
          ...oldStats,
          total,
          disabled,
          muted,
          error,
          snoozed
        }));
      }
    } catch (_e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.alertStats.loadError', {
          defaultMessage: 'Unable to load rule stats'
        })
      });
    } finally {
      setLoading(false);
    }
  }, [consumers, http, ruleTypeIds, toasts]);
  (0, _react.useEffect)(() => {
    loadRuleStats();
  }, [loadRuleStats]);
  return (0, _react.useMemo)(() => {
    const disabledStatsComponent = /*#__PURE__*/_react.default.createElement(Stat, {
      title: stats.disabled,
      description: _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.alertStats.disabled', {
        defaultMessage: 'Disabled'
      }),
      color: "primary",
      titleColor: stats.disabled > 0 ? 'primary' : '',
      titleSize: "xs",
      isLoading: loading,
      "data-test-subj": "statDisabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    });
    const snoozedStatsComponent = /*#__PURE__*/_react.default.createElement(Stat, {
      title: stats.muted + stats.snoozed,
      description: _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.alertStats.muted', {
        defaultMessage: 'Snoozed'
      }),
      color: "primary",
      titleColor: stats.muted + stats.snoozed > 0 ? 'primary' : '',
      titleSize: "xs",
      isLoading: loading,
      "data-test-subj": "statMuted",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    });
    const errorStatsComponent = /*#__PURE__*/_react.default.createElement(Stat, {
      title: stats.error,
      description: _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.alertStats.errors', {
        defaultMessage: 'Errors'
      }),
      color: "primary",
      titleColor: stats.error > 0 ? 'primary' : '',
      titleSize: "xs",
      isLoading: loading,
      "data-test-subj": "statErrors",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    });
    return [/*#__PURE__*/_react.default.createElement(Stat, {
      title: stats.total,
      description: _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.alertStats.ruleCount', {
        defaultMessage: 'Rule count'
      }),
      color: "primary",
      titleSize: "xs",
      isLoading: loading,
      "data-test-subj": "statRuleCount",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }), disabledStatsComponent, snoozedStatsComponent, errorStatsComponent, /*#__PURE__*/_react.default.createElement(Divider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "manageRulesPageButton",
      href: manageRulesHref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.globalAlerts.manageRulesButtonLabel', {
      defaultMessage: 'Manage Rules'
    }))].reverse();
  }, [loading, manageRulesHref, stats.disabled, stats.error, stats.muted, stats.snoozed, stats.total]);
};
exports.useRuleStats = useRuleStats;