"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryWidgetFullSize = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _alert_counts = require("./alert_counts");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alert_summary_widget/components/alert_summary_widget_full_size.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertSummaryWidgetFullSize = ({
  activeAlertCount,
  activeAlerts,
  chartProps: {
    themeOverrides,
    onBrushEnd
  } = {},
  dateFormat,
  recoveredAlertCount,
  timeZone,
  hideChart,
  hideStats,
  dependencyProps: {
    baseTheme
  }
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartData = activeAlerts.map(alert => alert.doc_count);
  const domain = {
    max: Math.max(...chartData) * 1.1,
    // add 10% headroom
    min: Math.min(...chartData) * 0.9 // add 10% floor
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    element: "div",
    "data-test-subj": "alertSummaryWidgetFullSize",
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, !hideStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "alertSummaryWidgetFullSizeStats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_counts.AlertCounts, {
    activeAlertCount: activeAlertCount,
    recoveredAlertCount: recoveredAlertCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })), !hideChart && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertSummaryWidgetFullSizeChartContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', 170],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: tooltip => (0, _moment.default)(tooltip.value).format(dateFormat || _constants.TOOLTIP_DATE_FORMAT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: _charts.Position.Right,
    theme: [...(themeOverrides ? Array.isArray(themeOverrides) ? themeOverrides : [themeOverrides] : []), {
      chartPaddings: {
        top: 7
      }
    }],
    onBrushEnd: onBrushEnd,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    gridLine: {
      visible: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    integersOnly: true,
    ticks: 4,
    domain: domain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "right",
    position: _charts.Position.Right,
    gridLine: {
      visible: true
    },
    integersOnly: true,
    ticks: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "Active"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['doc_count'],
    color: [euiTheme.colors.vis.euiColorVis0],
    data: activeAlerts,
    lineSeriesStyle: {
      line: {
        strokeWidth: 2
      },
      point: {
        visible: 'never'
      }
    },
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    timeZone: timeZone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }))));
};
exports.AlertSummaryWidgetFullSize = AlertSummaryWidgetFullSize;