"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateConnectorFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/create_connector_flyout/create_connector_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateConnectorFilter = ({
  searchValue,
  onSearchValueChange
}) => {
  const handleSearchChange = e => {
    const newValue = e.target.value;
    onSearchValueChange(newValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorAdd.searchConnectorLabel', {
      defaultMessage: 'Filter available connector types'
    }),
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorAdd.searchConnector', {
      defaultMessage: 'Search'
    }),
    "data-test-subj": "createConnectorsModalSearch",
    onChange: handleSearchChange,
    value: searchValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  })));
};
exports.CreateConnectorFilter = CreateConnectorFilter;