"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorOverrides = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_ALLOCATIONS = 0;
const DEFAULT_NUM_THREADS = 1;

// TODO remove when https://github.com/elastic/kibana/issues/231016 is resolved
const connectorOverrides = connectorId => {
  switch (connectorId) {
    case '.inference':
      // explicit check to see if this field exists as it only exists in serverless
      const formSerializer = data => {
        var _data$config, _data$config$provider;
        if (data && ((_data$config = data.config) === null || _data$config === void 0 ? void 0 : (_data$config$provider = _data$config.providerConfig) === null || _data$config$provider === void 0 ? void 0 : _data$config$provider.max_number_of_allocations) !== undefined) {
          var _data$config2;
          const providerConfig = (_data$config2 = data.config) === null || _data$config2 === void 0 ? void 0 : _data$config2.providerConfig;
          const {
            max_number_of_allocations: maxAllocations,
            ...restProviderConfig
          } = providerConfig || {};
          return {
            ...data,
            config: {
              ...data.config,
              providerConfig: {
                ...restProviderConfig,
                adaptive_allocations: {
                  enabled: true,
                  min_number_of_allocations: MIN_ALLOCATIONS,
                  ...(maxAllocations ? {
                    max_number_of_allocations: maxAllocations
                  } : {})
                },
                // Temporary solution until the endpoint is updated to no longer require it and to set its own default for this value
                num_threads: DEFAULT_NUM_THREADS
              }
            }
          };
        }
        return data;
      };
      const formDeserializer = data => {
        var _data$config3, _data$config3$provide, _data$config3$provide2;
        if (data && (_data$config3 = data.config) !== null && _data$config3 !== void 0 && (_data$config3$provide = _data$config3.providerConfig) !== null && _data$config3$provide !== void 0 && (_data$config3$provide2 = _data$config3$provide.adaptive_allocations) !== null && _data$config3$provide2 !== void 0 && _data$config3$provide2.max_number_of_allocations) {
          var _adaptive_allocations;
          return {
            ...data,
            config: {
              ...data.config,
              providerConfig: {
                ...data.config.providerConfig,
                max_number_of_allocations: (_adaptive_allocations = data.config.providerConfig.adaptive_allocations) === null || _adaptive_allocations === void 0 ? void 0 : _adaptive_allocations.max_number_of_allocations,
                // remove the adaptive_allocations from the data config as form does not expect it
                adaptive_allocations: undefined
              }
            }
          };
        }
        return data;
      };
      return {
        formDeserializer,
        formSerializer,
        shouldHideConnectorSettingsTitle: true
      };
  }
};
exports.connectorOverrides = connectorOverrides;