"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _use_create_connector = require("../../hooks/use_create_connector");
var _connector_form = require("./connector_form");
var _action_connector_api = require("../../lib/action_connector_api");
var _components = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/connector_add_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorAddModal = ({
  actionType: tempActionType,
  onClose,
  postSaveEventHandler,
  actionTypeRegistry
}) => {
  var _actionType$id, _actionTypeModel$subt;
  const {
    application: {
      capabilities
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [actionType, setActionType] = (0, _react.useState)(tempActionType);
  const [loadingActionTypes, setLoadingActionTypes] = (0, _react.useState)(false);
  const [allActionTypes, setAllActionTypes] = (0, _react.useState)(undefined);
  const {
    isLoading: isSavingConnector,
    createConnector
  } = (0, _use_create_connector.useCreateConnector)();
  const isMounted = (0, _react.useRef)(false);
  const containerRef = (0, _react.useRef)(null);
  const [initialConnector, setInitialConnector] = (0, _react.useState)({
    actionTypeId: (_actionType$id = actionType === null || actionType === void 0 ? void 0 : actionType.id) !== null && _actionType$id !== void 0 ? _actionType$id : '',
    isDeprecated: false,
    config: {},
    secrets: {},
    isMissingSecrets: false
  });
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const actionTypeModel = actionTypeRegistry.get(actionType.id);
  const groupActionTypeModel = actionTypeModel ? ((_actionTypeModel$subt = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subtype) !== null && _actionTypeModel$subt !== void 0 ? _actionTypeModel$subt : []).filter(item => {
    var _allActionTypes$item$;
    return allActionTypes === null || allActionTypes === void 0 ? void 0 : (_allActionTypes$item$ = allActionTypes[item.id]) === null || _allActionTypes$item$ === void 0 ? void 0 : _allActionTypes$item$.enabledInConfig;
  }).map(subtypeAction => ({
    ...actionTypeRegistry.get(subtypeAction.id),
    name: subtypeAction.name
  })) : [];
  const groupActionButtons = (groupActionTypeModel === null || groupActionTypeModel === void 0 ? void 0 : groupActionTypeModel.length) > 1 ? groupActionTypeModel.map(gAction => ({
    id: gAction.id,
    label: gAction.name,
    'data-test-subj': `${gAction.id}Button`
  })) : [];
  const resetConnectorForm = (0, _react.useRef)();
  const setResetForm = reset => {
    resetConnectorForm.current = reset;
  };
  const onChangeGroupAction = id => {
    if (allActionTypes && allActionTypes[id]) {
      setActionType(allActionTypes[id]);
      setInitialConnector({
        actionTypeId: id,
        isDeprecated: false,
        config: {},
        secrets: {},
        isMissingSecrets: false
      });
      if (resetConnectorForm.current) {
        resetConnectorForm.current({
          resetValues: true,
          defaultValue: {
            actionTypeId: id,
            isDeprecated: false,
            config: {},
            secrets: {}
          }
        });
      }
    }
  };
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isSavingConnector || isSubmitting;
  const validateAndCreateConnector = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the modal meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */

      const {
        actionTypeId,
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        actionTypeId,
        name: name !== null && name !== void 0 ? name : '',
        config,
        secrets
      };
      const createdConnector = await createConnector(validConnector);
      return createdConnector;
    } else {
      // point the user to the first invalid field
      const container = containerRef.current;
      if (!container) return;
      const selector = 'input[aria-invalid="true"]';
      const firstInputInvalid = container.querySelector(selector);
      if (firstInputInvalid) {
        window.requestAnimationFrame(() => {
          firstInputInvalid.focus({
            preventScroll: false
          });
        });
      }
    }
  }, [submit, preSubmitValidator, createConnector]);
  const closeModal = (0, _react.useCallback)(() => {
    onClose();
  }, [onClose]);
  const onSubmit = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      closeModal();
      if (postSaveEventHandler) {
        postSaveEventHandler(createdConnector);
      }
    }
  }, [validateAndCreateConnector, closeModal, postSaveEventHandler]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setLoadingActionTypes(true);
        const availableActionTypes = await (0, _action_connector_api.loadActionTypes)({
          http
        });
        setLoadingActionTypes(false);
        const index = {};
        for (const actionTypeItem of availableActionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setAllActionTypes(index);
      } catch (e) {
        if (toasts) {
          toasts.addDanger({
            title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
              defaultMessage: 'Unable to load connector types'
            })
          });
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    className: "actConnectorModal",
    css: (0, _react2.css)`
        z-index: 9000;
        width: ${actionTypeRegistry.get(actionType.id).modalWidth};
        overflow-y: auto;
      `,
    "data-test-subj": "connectorAddModal",
    onClose: closeModal,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }, actionTypeModel && actionTypeModel.iconClass ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionTypeModel.iconClass,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    size: "s",
    component: "h3",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{actionTypeName} connector",
    id: "xpack.triggersActionsUI.sections.addModalConnectorForm.flyoutTitle",
    values: {
      actionTypeName: actionType.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 21
    }
  }))), actionTypeModel && actionTypeModel.isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "betaBadgeFlexItem",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    "data-test-subj": "betaBadge",
    label: _translations.TECH_PREVIEW_LABEL,
    tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, loadingActionTypes ? /*#__PURE__*/_react.default.createElement(_components.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.connectorAddModal.loadingConnectorTypesDescription",
    defaultMessage: "Loading connector types\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupActionTypeModel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "m",
    color: "primary",
    legend: "",
    options: groupActionButtons,
    idSelected: actionType.id,
    onChange: onChangeGroupAction,
    "data-test-subj": "slackTypeChangeButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
    actionTypeModel: actionTypeModel,
    connector: initialConnector,
    isEdit: false,
    onChange: setFormState,
    setResetForm: setResetForm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }), preSubmitValidationErrorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    isLoading: isSaving,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.addModalConnectorForm.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), canSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    "data-test-subj": "saveActionButtonModal",
    type: "submit",
    iconType: "check",
    isLoading: isSaving,
    disabled: hasErrors,
    onClick: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.addModalConnectorForm.saveButtonLabel",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 15
    }
  })) : null)));
};

// eslint-disable-next-line import/no-default-export
exports.default = ConnectorAddModal;
module.exports = exports.default;