"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleTemplate = loadRuleTemplate;
var _constants = require("../../constants");
var _common_transformations = require("../rule_api/common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRuleTemplate({
  http,
  templateId
}) {
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule_template/${encodeURIComponent(templateId)}`);
  return (0, _common_transformations.transformRuleTemplate)(res);
}