"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateQueryDelaySettings = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  ...rest
}) => ({
  ...rest
});
const updateQueryDelaySettings = async ({
  http,
  queryDelaySettings
}) => {
  let body;
  try {
    body = JSON.stringify({
      delay: queryDelaySettings.delay
    });
  } catch (e) {
    throw new Error(`Unable to parse query delay settings update params: ${e}`);
  }
  const res = await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_query_delay`, {
    body
  });
  return rewriteBodyRes(res);
};
exports.updateQueryDelaySettings = updateQueryDelaySettings;