"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadActionErrorLog = void 0;
var _constants = require("../../constants");
var _get_filter = require("./get_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SORT_MAP = {
  timestamp: '@timestamp'
};

// Remaps sorting keys to ones that the server knows how to handle
const getRenamedSort = sort => {
  if (!sort) {
    return [];
  }
  return sort.map(o => {
    const sortField = Object.keys(o)[0];
    const sortOrder = o[Object.keys(o)[0]];
    return {
      [SORT_MAP[sortField] || sortField]: {
        ...sortOrder
      }
    };
  });
};
const loadActionErrorLog = ({
  id,
  http,
  dateStart,
  dateEnd,
  runId,
  message,
  perPage = 10,
  page = 0,
  sort,
  namespace,
  withAuth = false
}) => {
  const renamedSort = getRenamedSort(sort);
  const filter = (0, _get_filter.getFilter)({
    runId,
    message
  });
  return http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${id}/_action_error_log`, {
    query: {
      date_start: dateStart,
      date_end: dateEnd,
      filter: filter.length ? filter.join(' and ') : undefined,
      per_page: perPage,
      // Need to add the + 1 for pages because APIs are 1 indexed,
      // whereas data grid sorts are 0 indexed.
      page: page + 1,
      sort: renamedSort.length ? JSON.stringify(renamedSort) : undefined,
      namespace,
      with_auth: withAuth
    }
  });
};
exports.loadActionErrorLog = loadActionErrorLog;