"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMillisForDisplay = formatMillisForDisplay;
exports.shouldShowDurationWarning = shouldShowDurationWarning;
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _common = require("@kbn/alerting-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatMillisForDisplay(value) {
  if (!value) {
    return '00:00:00.000';
  }
  const duration = _moment.default.duration(value);
  const durationString = [duration.hours(), duration.minutes(), duration.seconds()].map(v => (0, _lodash.padStart)(`${v}`, 2, '0')).join(':');

  // add millis
  const millisString = (0, _lodash.padStart)(`${duration.milliseconds()}`, 3, '0');
  return `${durationString}.${millisString}`;
}
function shouldShowDurationWarning(ruleType, avgDurationMillis) {
  if (!ruleType || !ruleType.ruleTaskTimeout) {
    return false;
  }
  const ruleTypeTimeout = ruleType.ruleTaskTimeout;
  const ruleTypeTimeoutMillis = (0, _common.parseDuration)(ruleTypeTimeout);
  return avgDurationMillis > ruleTypeTimeoutMillis;
}