"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleTemplate = useRuleTemplate;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../common/lib/kibana");
var _get_rule_template = require("../lib/rule_template_api/get_rule_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRuleTemplate(props) {
  const {
    templateId
  } = props;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    if (!templateId) {
      throw new Error('templateId not defined');
    }
    return (0, _get_rule_template.loadRuleTemplate)({
      http,
      templateId
    });
  };
  const enabled = !!templateId && templateId !== 'undefined';
  const {
    data,
    error,
    isFetching,
    isError,
    isLoadingError,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getRuleTemplate', templateId],
    queryFn,
    enabled,
    refetchOnWindowFocus: false,
    retry: false
  });
  return {
    isLoading: enabled && (isLoading || isFetching),
    isError: isError || isLoadingError,
    error,
    data
  };
}