"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConnectorContext = void 0;
var _react = require("react");
var _connector_context = require("./connector_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConnectorContext = () => {
  const connectorContext = (0, _react.useContext)(_connector_context.ConnectorContext);
  if (!connectorContext) {
    throw new Error('useConnectorContext must be used within a ConnectorProvider and have a defined value.');
  }
  return connectorContext;
};
exports.useConnectorContext = useConnectorContext;