"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesDeleteModalConfirmation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../sections/rules_list/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/rules_delete_modal_confirmation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RulesDeleteModalConfirmation = ({
  confirmButtonText,
  confirmModalText,
  onCancel,
  onConfirm,
  showWarningText,
  warningText
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: confirmButtonText,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "rulesDeleteConfirmation",
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _translations.CANCEL_BUTTON_TEXT,
    confirmButtonText: confirmButtonText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, confirmModalText), showWarningText && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warningText),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }));
};
exports.RulesDeleteModalConfirmation = RulesDeleteModalConfirmation;