"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCheck = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _Option = require("fp-ts/Option");
var _pipeable = require("fp-ts/pipeable");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fetch_ui_health_status = require("@kbn/alerts-ui-shared/src/common/apis/fetch_ui_health_status");
var _fetch_alerting_framework_health = require("@kbn/alerts-ui-shared/src/common/apis/fetch_alerting_framework_health");
var _health_context = require("../context/health_context");
var _kibana = require("../../common/lib/kibana");
var _center_justified_spinner = require("./center_justified_spinner");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/health_check.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const alertingHealthCheckCss = euiTheme => (0, _react2.css)`
  .alertingHealthCheck__body {
    padding-left: calc(${euiTheme.size.base} * 2);
    padding-right: calc(${euiTheme.size.base} * 2);
  }

  .alertingFlyoutHealthCheck__body {
    padding-left: calc(${euiTheme.size.base} * 2);
    padding-right: calc(${euiTheme.size.base} * 2);
    margin-top: ${euiTheme.size.base};
  }
`;
const HealthCheck = ({
  children,
  waitForCheck,
  inFlyout = false
}) => {
  const {
    http,
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    setLoadingHealthCheck
  } = (0, _health_context.useHealthContext)();
  const [alertingHealth, setAlertingHealth] = _react.default.useState(_Option.none);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  _react.default.useEffect(() => {
    (async function () {
      setLoadingHealthCheck(true);
      const triggersActionsUiHealthStatus = await (0, _fetch_ui_health_status.fetchUiHealthStatus)({
        http
      });
      const healthStatus = {
        ...triggersActionsUiHealthStatus,
        isSufficientlySecure: false,
        hasPermanentEncryptionKey: false
      };
      if (healthStatus.isRulesAvailable) {
        // Get the framework health, but if not available, do NOT cause the
        // framework health errors/toasts to appear, since the state is
        // actually unknown. These also need to be set to clear the busy
        // indicator.
        const alertingHealthResult = await getAlertingFrameworkHealth(http);
        if ((0, _Option.isSome)(alertingHealthResult)) {
          healthStatus.isSufficientlySecure = alertingHealthResult.value.isSufficientlySecure;
          healthStatus.hasPermanentEncryptionKey = alertingHealthResult.value.hasPermanentEncryptionKey;
        } else {
          healthStatus.isSufficientlySecure = true;
          healthStatus.hasPermanentEncryptionKey = true;
        }
        setAlertingHealth((0, _Option.some)(healthStatus));
      }
      setLoadingHealthCheck(false);
    })();
  }, [http, setLoadingHealthCheck]);
  const className = inFlyout ? 'alertingFlyoutHealthCheck' : 'alertingHealthCheck';
  return (0, _pipeable.pipe)(alertingHealth, (0, _Option.fold)(() => waitForCheck ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children), healthCheck => {
    return healthCheck !== null && healthCheck !== void 0 && healthCheck.isSufficientlySecure && healthCheck !== null && healthCheck !== void 0 && healthCheck.hasPermanentEncryptionKey ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : !healthCheck.isRulesAvailable ? /*#__PURE__*/_react.default.createElement(AlertsError, {
      docLinks: docLinks,
      className: className,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }) : !healthCheck.isSufficientlySecure && !healthCheck.hasPermanentEncryptionKey ? /*#__PURE__*/_react.default.createElement(ApiKeysAndEncryptionError, {
      docLinks: docLinks,
      className: className,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }) : !healthCheck.hasPermanentEncryptionKey ? /*#__PURE__*/_react.default.createElement(EncryptionError, {
      docLinks: docLinks,
      className: className,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(ApiKeysDisabledError, {
      docLinks: docLinks,
      className: className,
      euiTheme: euiTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    });
  }));
};

// Return as an Option, returning none if error occurred getting health.
// Currently, alerting health returns a 403 if the user is not authorized
// for rules.
exports.HealthCheck = HealthCheck;
async function getAlertingFrameworkHealth(http) {
  try {
    return (0, _Option.some)(await (0, _fetch_alerting_framework_health.fetchAlertingFrameworkHealth)({
      http
    }));
  } catch (err) {
    return _Option.none;
  }
}
const EncryptionError = ({
  docLinks,
  className,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "watchesApp",
  "data-test-subj": "actionNeededEmptyPrompt",
  className: className,
  css: alertingHealthCheckCss(euiTheme),
  titleSize: "xs",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.healthCheck.encryptionErrorTitle",
    defaultMessage: "Additional setup required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("div", {
    className: `${className}__body`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "banner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.encryptionErrorBeforeKey', {
    defaultMessage: 'You must configure an encryption key to use Alerting. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.generalSettings,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.encryptionErrorAction', {
    defaultMessage: 'Learn more.'
  })))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 148,
    columnNumber: 3
  }
});
const ApiKeysDisabledError = ({
  docLinks,
  className,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "watchesApp",
  "data-test-subj": "actionNeededEmptyPrompt",
  className: className,
  css: alertingHealthCheckCss(euiTheme),
  titleSize: "xs",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.healthCheck.apiKeysDisabledErrorTitle",
    defaultMessage: "Additional setup required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("div", {
    className: `${className}__body`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "banner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.apiKeysDisabledError', {
    defaultMessage: 'You must enable API keys to use Alerting. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.security.elasticsearchEnableApiKeys,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.apiKeysDisabledErrorAction', {
    defaultMessage: 'Learn more.'
  })))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 186,
    columnNumber: 3
  }
});
const AlertsError = ({
  docLinks,
  className,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "watchesApp",
  "data-test-subj": "alertsNeededEmptyPrompt",
  className: className,
  css: alertingHealthCheckCss(euiTheme),
  titleSize: "xs",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.healthCheck.alertsErrorTitle",
    defaultMessage: "You must enable Alerting and Actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("div", {
    className: `${className}__body`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "banner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.alertsError', {
    defaultMessage: 'To create a rule, you must enable the alerting and actions plugins. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.generalSettings,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.alertsErrorAction', {
    defaultMessage: 'Learn how.'
  })))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 225,
    columnNumber: 3
  }
});
const ApiKeysAndEncryptionError = ({
  docLinks,
  className,
  euiTheme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "watchesApp",
  "data-test-subj": "actionNeededEmptyPrompt",
  className: className,
  css: alertingHealthCheckCss(euiTheme),
  titleSize: "xs",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.healthCheck.apiKeysAndEncryptionErrorTitle",
    defaultMessage: "Additional setup required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("div", {
    className: `${className}__body`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "banner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.apiKeysAndEncryptionError', {
    defaultMessage: 'You must enable API keys and configure an encryption key to use Alerting. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.setupPrerequisites,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.components.healthCheck.apiKeysAndEncryptionErrorAction', {
    defaultMessage: 'Learn more.'
  })))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 257,
    columnNumber: 3
  }
});