"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeHandler = void 0;
var _transform_health_service = require("../../../lib/alerting/transform_health_rule_type/transform_health_service");
var _error_utils = require("../../utils/error_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeHandler = async (ctx, req, res) => {
  try {
    const esClient = (await ctx.core).elasticsearch.client;
    const body = await esClient.asCurrentUser.transform.getTransform({
      size: 1000,
      ...req.params
    });
    const alerting = await ctx.alerting;
    if (alerting) {
      const rulesClient = await alerting.getRulesClient();
      const transformHealthService = (0, _transform_health_service.transformHealthServiceProvider)({
        esClient: esClient.asCurrentUser,
        rulesClient
      });

      // @ts-ignore
      await transformHealthService.populateTransformsWithAssignedRules(body.transforms);
    }
    return res.ok({
      body
    });
  } catch (e) {
    return res.customError((0, _error_utils.wrapError)((0, _error_utils.wrapEsError)(e)));
  }
};
exports.routeHandler = routeHandler;