"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformUiPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _register_feature = require("./register_feature");
var _alerting = require("./alerting");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class TransformUiPlugin {
  constructor(initializerContext) {
    var _initializerContext$c;
    (0, _defineProperty2.default)(this, "isServerless", false);
    (0, _defineProperty2.default)(this, "experimentalFeatures", {
      ruleFormV2Enabled: false
    });
    this.isServerless = initializerContext.env.packageInfo.buildFlavor === 'serverless';
    this.experimentalFeatures = (_initializerContext$c = initializerContext.config.get().experimental) !== null && _initializerContext$c !== void 0 ? _initializerContext$c : this.experimentalFeatures;
  }
  setup(coreSetup, pluginsSetup) {
    const {
      management,
      home,
      triggersActionsUi
    } = pluginsSetup;

    // Register management section
    const esSection = management.sections.section.data;
    esSection.registerApp({
      id: 'transform',
      title: _i18n.i18n.translate('xpack.transform.appTitle', {
        defaultMessage: 'Transforms'
      }),
      order: 5,
      mount: async params => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app/mount_management_section')));
        return mountManagementSection(coreSetup, params, this.isServerless, this.experimentalFeatures);
      }
    });
    (0, _register_feature.registerFeature)(home);
    if (triggersActionsUi) {
      triggersActionsUi.ruleTypeRegistry.register((0, _alerting.getTransformHealthRuleType)());
    }
  }
  start() {}
  stop() {}
}
exports.TransformUiPlugin = TransformUiPlugin;