"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformManagementSection = exports.TransformManagement = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _app_dependencies = require("../../app_dependencies");
var _transform_stats = require("../../../../common/types/transform_stats");
var _use_get_transform_stats = require("../../hooks/use_get_transform_stats");
var _serverless_context = require("../../serverless_context");
var _reauthorization_utils = require("../../common/reauthorization_utils");
var _common = require("../../common");
var _hooks = require("../../hooks");
var _navigation = require("../../common/navigation");
var _capabilities_wrapper = require("../../components/capabilities_wrapper");
var _toast_notification_text = require("../../components/toast_notification_text");
var _navigation2 = require("../../services/navigation");
var _search_selection = require("./components/search_selection");
var _transform_list = require("./components/transform_list");
var _transforms_stats_bar = require("./components/transform_list/transforms_stats_bar");
var _transform_alerting_flyout = require("../../../alerting/transform_alerting_flyout");
var _dangling_task_warning = require("./components/dangling_task_warning/dangling_task_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/transform_management_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    dialog: (0, _react2.css)`
      width: calc(${euiTheme.size.l} * 30);
      min-height: calc(${euiTheme.size.l} * 25);
    `
  };
};
const getDefaultTransformListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: _common.TRANSFORM_LIST_COLUMN.ID,
  sortDirection: 'asc',
  showPerPageOptions: true
});
const ErrorMessageCallout = ({
  text,
  errorMessage
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text, ' ', errorMessage !== null && /*#__PURE__*/_react.default.createElement(_toast_notification_text.ToastNotificationText, {
      inline: true,
      forceModal: true,
      text: errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    })),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
const TransformManagement = () => {
  const {
    esTransform
  } = (0, _hooks.useDocumentationLinks)();
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const {
    dataViewEditor
  } = (0, _app_dependencies.useAppDependencies)();
  const styles = useStyles();
  const [transformPageState, setTransformPageState] = (0, _mlUrlState.usePageUrlState)('transform', getDefaultTransformListState());
  const {
    isInitialLoading: transformNodesInitialLoading,
    error: transformNodesErrorMessage,
    data: transformNodesData = 0
  } = (0, _hooks.useGetTransformNodes)({
    enabled: true
  });
  const transformNodes = transformNodesErrorMessage === null ? transformNodesData : 0;
  const {
    isInitialLoading: transformsInitialLoading,
    isLoading: transformsWithoutStatsLoading,
    error: transformsErrorMessage,
    data: {
      transforms: transformsWithoutStats,
      transformIdsWithoutConfig
    }
  } = (0, _hooks.useGetTransforms)({
    enabled: !transformNodesInitialLoading && transformNodes > 0
  });
  const {
    isLoading: transformsStatsLoading,
    error: transformsStatsErrorMessage,
    data: transformsStats
  } = (0, _use_get_transform_stats.useGetTransformsStats)({
    basic: true,
    enabled: !transformNodesInitialLoading && transformNodes > 0
  });
  const transforms = (0, _react.useMemo)(() => {
    if (!transformsStats) return transformsWithoutStats;
    return transformsWithoutStats.map(t => {
      const stats = transformsStats.transforms.find(d => t.config.id === d.id);

      // A newly created transform might not have corresponding stats yet.
      // If that's the case we just skip the transform and don't add it to the transform list yet.
      if (!(0, _transform_stats.isTransformStats)(stats)) {
        return t;
      }
      return {
        ...t,
        stats
      };
    });
  }, [transformsStats, transformsWithoutStats]);
  const isInitialLoading = transformNodesInitialLoading || transformsInitialLoading;
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const unauthorizedTransformsWarning = (0, _react.useMemo)(() => {
    const unauthorizedCnt = transforms.filter(t => (0, _reauthorization_utils.needsReauthorization)(t)).length;
    if (!unauthorizedCnt) return null;
    const insufficientPermissionsMsg = _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.insufficientPermissionsMsg', {
      defaultMessage: '{unauthorizedCnt, plural, one {A transform was created with insufficient permissions.} other {# transforms were created with insufficient permissions.}}',
      values: {
        unauthorizedCnt
      }
    });
    const actionMsg = canStartStopTransform ? _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.reauthorizeMsg', {
      defaultMessage: 'Reauthorize to start {unauthorizedCnt, plural, one {transform} other {# transforms}}.',
      values: {
        unauthorizedCnt
      }
    }) : _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.contactAdminMsg', {
      defaultMessage: 'Contact your administrator to request the required permissions.'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "alert",
      color: "warning",
      "data-test-subj": "transformPageReauthorizeCallout",
      title: `${insufficientPermissionsMsg} ${actionMsg}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 9
      }
    }));
  }, [transforms, canStartStopTransform]);
  const [isSearchSelectionVisible, setIsSearchSelectionVisible] = (0, _react.useState)(false);
  const [savedObjectId, setSavedObjectId] = (0, _react.useState)(null);
  const onCloseModal = (0, _react.useCallback)(() => setIsSearchSelectionVisible(false), []);
  const onOpenModal = () => setIsSearchSelectionVisible(true);
  const onSearchSelected = (0, _react.useCallback)((id, type) => {
    setSavedObjectId(id);
  }, []);
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView());
  const closeDataViewEditorRef = (0, _react.useRef)();
  const createNewDataView = (0, _react.useCallback)(() => {
    onCloseModal();
    closeDataViewEditorRef.current = dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.openEditor({
      onSave: async dataView => {
        if (dataView.id) {
          onSearchSelected(dataView.id, 'index-pattern');
        }
      },
      allowAdHocDataView: true
    });
  }, [dataViewEditor, onCloseModal, onSearchSelected]);
  (0, _react.useEffect)(function cleanUpDataViewEditorFlyout() {
    return () => {
      // Close the editor when unmounting
      if (closeDataViewEditorRef.current) {
        closeDataViewEditorRef.current();
      }
    };
  }, []);
  if (savedObjectId !== null) {
    return /*#__PURE__*/_react.default.createElement(_navigation.RedirectToCreateTransform, {
      savedObjectId: savedObjectId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 12
      }
    });
  }
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "documentationLink",
    "aria-label": _i18n.i18n.translate('xpack.transform.transformList.transformDocsLinkAriaLabel', {
      defaultMessage: 'Transform documentation link'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformList.transformDocsLinkText",
    defaultMessage: "Transform docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "transformAppTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformTitle",
      defaultMessage: "Transforms",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformDescription",
      defaultMessage: "Use transforms to pivot existing Elasticsearch indices into summarized entity-centric indices or to create an indexed view of the latest documents for fast access.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 11
      }
    }),
    rightSideItems: [docsLink],
    bottomBorder: true,
    paddingSize: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: 'none',
    "data-test-subj": "transformPageTransformList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }, isInitialLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  })), !isInitialLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, unauthorizedTransformsWarning, showNodeInfo && transformNodesErrorMessage !== null && /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformNodesErrorPromptTitle",
      defaultMessage: "An error occurred getting the number of transform nodes.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 19
      }
    }),
    errorMessage: transformNodesErrorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 15
    }
  }), transformsErrorMessage !== null && /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformListErrorPromptTitle",
      defaultMessage: "An error occurred getting the transform list.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 19
      }
    }),
    errorMessage: transformsErrorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 15
    }
  }), transformsStatsErrorMessage !== null ? /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformStatsErrorPromptTitle",
      defaultMessage: "An error occurred getting the transform stats.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 19
      }
    }),
    errorMessage: transformsStatsErrorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 15
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_transforms_stats_bar.TransformStatsBar, {
    transformNodes: transformNodes,
    transformsList: transforms,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.AlertRulesManageContext.Provider, {
    value: (0, _transform_alerting_flyout.getAlertRuleManageContext)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_dangling_task_warning.DanglingTasksWarning, {
    transformIdsWithoutConfig: transformIdsWithoutConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 15
    }
  }), (transformNodes > 0 || transforms.length > 0) && /*#__PURE__*/_react.default.createElement(_transform_list.TransformList, {
    isLoading: transformsWithoutStatsLoading,
    onCreateTransform: onOpenModal,
    transformNodes: transformNodes,
    transforms: transforms,
    transformsLoading: transformsWithoutStatsLoading,
    transformsStatsLoading: transformsStatsLoading,
    pageState: transformPageState,
    updatePageState: setTransformPageState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.TransformAlertFlyoutWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 15
    }
  })))), isSearchSelectionVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCloseModal,
    css: styles.dialog,
    "aria-label": _i18n.i18n.translate('xpack.transform.transformList.createTransformSearchModalTitle', {
      defaultMessage: 'Create Transform - Select Data Source'
    }),
    "data-test-subj": "transformSelectSourceModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_selection.SearchSelection, {
    onSearchSelected: onSearchSelected,
    canEditDataView: canEditDataView,
    createNewDataView: createNewDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 11
    }
  })));
};
exports.TransformManagement = TransformManagement;
const TransformManagementSection = () => {
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation2.breadcrumbService.setBreadcrumbs(_navigation2.BREADCRUMB_SECTION.HOME);
    _navigation2.docTitleService.setTitle('home');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_capabilities_wrapper.CapabilitiesWrapper, {
    requiredCapabilities: 'canGetTransform',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(TransformManagement, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  })));
};
exports.TransformManagementSection = TransformManagementSection;