"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformStatsBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _serverless_context = require("../../../../serverless_context");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _stats_bar = require("../stats_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/transforms_stats_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createTransformStats(transformNodes, transformsList, showNodeInfo) {
  const transformStats = {
    total: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.totalTransformsLabel', {
        defaultMessage: 'Total transforms'
      }),
      value: 0,
      show: true
    },
    batch: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.batchTransformsLabel', {
        defaultMessage: 'Batch'
      }),
      value: 0,
      show: true
    },
    continuous: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.continuousTransformsLabel', {
        defaultMessage: 'Continuous'
      }),
      value: 0,
      show: true
    },
    failed: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.failedTransformsLabel', {
        defaultMessage: 'Failed'
      }),
      value: 0,
      show: false
    },
    started: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.startedTransformsLabel', {
        defaultMessage: 'Started'
      }),
      value: 0,
      show: true
    }
  };
  if (showNodeInfo) {
    transformStats.nodes = {
      label: _i18n.i18n.translate('xpack.transform.statsBar.transformNodesLabel', {
        defaultMessage: 'Nodes'
      }),
      value: transformNodes,
      show: true
    };
  }
  if (transformsList === undefined) {
    return transformStats;
  }
  let failedTransforms = 0;
  let startedTransforms = 0;
  transformsList.forEach(transform => {
    if (transform.mode === _constants.TRANSFORM_MODE.CONTINUOUS && typeof transformStats.continuous.value === 'number') {
      transformStats.continuous.value++;
    } else if (transform.mode === _constants.TRANSFORM_MODE.BATCH && typeof transformStats.batch.value === 'number') {
      transformStats.batch.value++;
    }
    if (transform.stats) {
      if (transform.stats.state === _constants.TRANSFORM_STATE.FAILED) {
        failedTransforms++;
      } else if (transform.stats.state === _constants.TRANSFORM_STATE.STARTED) {
        startedTransforms++;
      }
    }
  });
  transformStats.total.value = transformsList.length;
  transformStats.started.value = startedTransforms;
  if (failedTransforms !== 0) {
    transformStats.failed.value = failedTransforms;
    transformStats.failed.show = true;
  } else {
    transformStats.failed.show = false;
  }
  return transformStats;
}
const TransformStatsBar = ({
  transformNodes,
  transformsList
}) => {
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const refreshTransformList = (0, _hooks.useRefreshTransformList)();
  const {
    esNodeRoles
  } = (0, _hooks.useDocumentationLinks)();
  const transformStats = createTransformStats(transformNodes, transformsList, showNodeInfo);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showNodeInfo && transformNodes === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformNodes.noTransformNodesCallOutTitle",
      defaultMessage: "There are no transform nodes available.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformNodes.noTransformNodesCallOutBody",
    defaultMessage: "You will not be able to create or run transforms. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: esNodeRoles,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.transform.transformNodes.noTransformNodesLearnMoreLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 23
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => refreshTransformList(),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformNodes.noTransformNodesRetryButtonText",
    defaultMessage: "Retry",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: transformStats,
    dataTestSub: 'transformStatsBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }));
};
exports.TransformStatsBar = TransformStatsBar;