"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowDetailsPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _constants = require("../../../../../../common/constants");
var _transform_stats = require("../../../../../../common/types/transform_stats");
var _serverless_context = require("../../../../serverless_context");
var _transform_list = require("../../../../common/transform_list");
var _hooks = require("../../../../hooks");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
var _expanded_row_column_view = require("./expanded_row_column_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/expanded_row_details_pane.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const notAvailableMessage = _i18n.i18n.translate('xpack.transform.transformList.transformDetails.notAvailable', {
  defaultMessage: 'n/a'
});
const ExpandedRowDetailsPane = ({
  item,
  onAlertEdit
}) => {
  var _item$alerting_rules;
  const {
    data: fullStats,
    isError,
    isLoading
  } = (0, _hooks.useGetTransformStats)(item.id, false, true);
  let displayStats = {};
  if (fullStats !== undefined && !isLoading && !isError) {
    displayStats = fullStats.transforms[0];
  } else if ((0, _transform_list.isTransformListRowWithStats)(item)) {
    displayStats = item.stats;
  }
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const stateItems = [{
    title: 'ID',
    description: item.id
  }];
  const configItems = (0, _react.useMemo)(() => {
    var _item$config$version, _item$config$descript, _formatHumanReadableD, _item$config$settings;
    const configs = [{
      title: 'transform_id',
      description: item.id
    }, {
      title: 'transform_version',
      description: (_item$config$version = item.config.version) !== null && _item$config$version !== void 0 ? _item$config$version : ''
    }, {
      title: 'description',
      description: (_item$config$descript = item.config.description) !== null && _item$config$descript !== void 0 ? _item$config$descript : ''
    }, {
      title: 'create_time',
      description: (_formatHumanReadableD = (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(item.config.create_time).unix() * 1000)) !== null && _formatHumanReadableD !== void 0 ? _formatHumanReadableD : ''
    }, {
      title: 'source_index',
      description: Array.isArray(item.config.source.index) ? item.config.source.index[0] : item.config.source.index
    }, {
      title: 'destination_index',
      description: item.config.dest.index
    }, {
      title: 'authorization',
      description: item.config.authorization ? JSON.stringify(item.config.authorization) : ''
    }];
    if ((0, _mlIsDefined.isDefined)((_item$config$settings = item.config.settings) === null || _item$config$settings === void 0 ? void 0 : _item$config$settings.num_failure_retries)) {
      var _item$config$settings2, _item$config$settings3;
      configs.push({
        title: 'num_failure_retries',
        description: (_item$config$settings2 = (_item$config$settings3 = item.config.settings) === null || _item$config$settings3 === void 0 ? void 0 : _item$config$settings3.num_failure_retries) !== null && _item$config$settings2 !== void 0 ? _item$config$settings2 : ''
      });
    }
    return configs;

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [item === null || item === void 0 ? void 0 : item.config]);
  const checkpointingItems = [];
  if ((0, _transform_stats.isTransformStats)(displayStats)) {
    stateItems.push({
      title: 'state',
      description: displayStats.state
    });
    if (showNodeInfo && displayStats.node !== undefined) {
      stateItems.push({
        title: 'node.name',
        description: displayStats.node.name
      });
    }
    if (displayStats.health !== undefined) {
      stateItems.push({
        title: 'health',
        description: /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
          healthStatus: (0, _constants.mapEsHealthStatus2TransformHealthStatus)(displayStats.health.status),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 11
          }
        })
      });
    }
    if (displayStats.checkpointing.changes_last_detected_at !== undefined) {
      checkpointingItems.push({
        title: 'changes_last_detected_at',
        description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(displayStats.checkpointing.changes_last_detected_at)
      });
    }
    if (displayStats.checkpointing.last !== undefined) {
      checkpointingItems.push({
        title: 'last.checkpoint',
        description: displayStats.checkpointing.last.checkpoint
      });
      if (displayStats.checkpointing.last.timestamp_millis !== undefined) {
        checkpointingItems.push({
          title: 'last.timestamp',
          description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(displayStats.checkpointing.last.timestamp_millis)
        });
        checkpointingItems.push({
          title: 'last.timestamp_millis',
          description: displayStats.checkpointing.last.timestamp_millis
        });
      }
    }
    if (displayStats.checkpointing.last_search_time !== undefined) {
      checkpointingItems.push({
        title: 'last_search_time',
        description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(displayStats.checkpointing.last_search_time)
      });
    }
    if (displayStats.checkpointing.next !== undefined) {
      checkpointingItems.push({
        title: 'next.checkpoint',
        description: displayStats.checkpointing.next.checkpoint
      });
      if (displayStats.checkpointing.next.checkpoint_progress !== undefined) {
        var _displayStats$checkpo, _displayStats$checkpo2;
        checkpointingItems.push({
          title: 'next.checkpoint_progress.total_docs',
          description: (_displayStats$checkpo = displayStats.checkpointing.next.checkpoint_progress.total_docs) !== null && _displayStats$checkpo !== void 0 ? _displayStats$checkpo : notAvailableMessage
        });
        checkpointingItems.push({
          title: 'next.checkpoint_progress.docs_remaining',
          description: (_displayStats$checkpo2 = displayStats.checkpointing.next.checkpoint_progress.docs_remaining) !== null && _displayStats$checkpo2 !== void 0 ? _displayStats$checkpo2 : notAvailableMessage
        });
        checkpointingItems.push({
          title: 'next.checkpoint_progress.percent_complete',
          description: typeof displayStats.checkpointing.next.checkpoint_progress.percent_complete === 'number' ? `${Math.round(displayStats.checkpointing.next.checkpoint_progress.percent_complete)}%` : notAvailableMessage
        });
      }
    }
    if (displayStats.checkpointing.operations_behind !== undefined) {
      checkpointingItems.push({
        title: 'operations_behind',
        description: displayStats.checkpointing.operations_behind
      });
    }
  }
  const state = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.stateTitle', {
      defaultMessage: 'State'
    }),
    items: stateItems,
    position: 'right'
  };
  const general = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.generalTitle', {
      defaultMessage: 'General'
    }),
    items: configItems,
    position: 'left'
  };
  const alertRuleItems = (_item$alerting_rules = item.alerting_rules) === null || _item$alerting_rules === void 0 ? void 0 : _item$alerting_rules.map(rule => {
    return {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: 'documentEdit',
        iconSide: 'left',
        onClick: () => {
          onAlertEdit(rule);
        },
        flush: "left",
        size: 'xs',
        iconSize: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 9
        }
      }, rule.name),
      description: rule.executionStatus.status
    };
  });
  const checkpointing = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.checkpointTitle', {
      defaultMessage: 'Checkpointing'
    }),
    items: checkpointingItems,
    position: 'right'
  };
  const alertingRules = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.alertRulesTitle', {
      defaultMessage: 'Alert rules'
    }),
    items: alertRuleItems,
    position: 'right'
  };
  return /*#__PURE__*/_react.default.createElement(_expanded_row_column_view.ExpandedRowColumnView, {
    sections: [general, state, checkpointing, ...(alertingRules.items ? [alertingRules] : [])],
    showErrorCallout: isError,
    dataTestSubj: 'transformDetailsTabContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 5
    }
  });
};
exports.ExpandedRowDetailsPane = ExpandedRowDetailsPane;